package com.javacodegeeks.basics.stringtolong;

public class StringToLongClass {

	public static void main(String[] args) {
		
		String str = "1234567890123";
		
		Long longNum = new Long(str);
		System.out.println("Use of constructor: longNum = "+longNum.longValue());
		
		long long1 = Long.parseLong(str);
		System.out.println("Use of parseLong: long1 = "+long1);
		
		long l1 = Long.valueOf(str).longValue();
		System.out.println("Use of valueOf: l1 = "+l1);
		
		// with a specified radix
		long long2 = Long.parseLong("-AAAAAAAA", 16);
		System.out.println("Use of parseLong with 16 radix: long2 = "+long2);
		
		// returns a Long object. radix=36 for ISO basic Latin alphabet
		Long l2 = Long.valueOf("JCG", 36);
		System.out.println("Use of valueOf with 36 radix: l2 = "+l2);

		// for octal format use 0
		long decLong1 = Long.decode("0776");
		System.out.println("Use of decode with octal format: decLong1 = "+decLong1);
		
		// for hex format use 0x or 0X or #
		long decLong2 = Long.decode("0xFFFFFFFFE");
		System.out.println("Use of decode with hex format: decLong2 = "+decLong2);
		
		// exception conditions
		try {
			long long3 = Long.parseLong("FFC", 8);
		} catch (NumberFormatException e) {
			System.err.println("NumberFormatException in parseLong, "+ e.getMessage());
		}
				
		try {
			Long l3 = Long.valueOf("hi");
		} catch (NumberFormatException e) {
			System.err.println("NumberFormatException in valueOf, "+ e.getMessage());
		}
		
		try {
			Long decLong3 = Long.decode("#FFG");
		} catch (NumberFormatException e) {
			System.err.println("NumberFormatException in decode, "+ e.getMessage());
		}
				
	}

}
