package com.javacodegeeks.corejava.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MyCollectionsExample {
	
	public static void main(String[] args) {
		
		List<Double>temperatureList = new ArrayList<Double>();
		
		temperatureList.add(33.9);
		temperatureList.add(37.8);
		temperatureList.add(40.5);
		temperatureList.add(15.3);
		temperatureList.add(25.6);
		
		// Print elements of temperatureList
		System.out.println(temperatureList);
		
		//Get maximum temperature from temperatureList
		Double max = Collections.max(temperatureList);
		System.out.println("Maximun temperature: "+max);
		
		//Get minimum temperature from temperatureList
		Double min = Collections.min(temperatureList);
		System.out.println("Minimum temperature: "+min);
		
		//Reverse the list
		Collections.reverse(temperatureList);
		System.out.println("Reversed List: "+temperatureList);
		
		//Copy elements from one list to another
		List<Double>newTemperatureList = new ArrayList<Double>(temperatureList.size());
		newTemperatureList.add(13.6);
		newTemperatureList.add(10.2);
		newTemperatureList.add(42.9);
		newTemperatureList.add(34.4);
		newTemperatureList.add(27.2);
		System.out.println("New temperature list: "+newTemperatureList);
		Collections.copy(newTemperatureList, temperatureList);
		System.out.println("New temperature list after copy: "+newTemperatureList);
		
		//Replaces all occurrences of one specified value in a list with another.
		Collections.replaceAll(temperatureList, 40.5, 0.0);
		System.out.println("After replaceAll: "+temperatureList);
		
	}

}
