package com.javacodegeeks.core.constructor;

public class Person {
	private String name;
	private int age;

	public Person() {	
		// no-argument constructor, which assigns predefined values
		this.name = "Unknown";
		this.age = 0;
	}

	public Person(String Name) {
		// constructor which assigns one predefined value an one based on the input value
		this.name = Name;
		this.age = 0;
	}

	public Person(String Name, int Age) {
		// constructor which assigns the given values
		this.name = Name;
		this.age = Age;
	}

	public String getName() {
		return name;
	}

	public int getAge() {
		return age;
	}

	public static void main(String args[]) {
		// We create three different objects, one with each constructor provided.
		Person person1 = new Person();
		Person person2 = new Person("Jim");
		Person person3 = new Person("John", 28);

		// We print their data.
		System.out.println("person1: " + person1.getName() +" is "+ person1.getAge() + " years old.");
		System.out.println("person2: " + person2.getName() +" is "+ person2.getAge() + " years old.");
		System.out.println("person3: " + person3.getName() +" is "+ person3.getAge() + " years old.");
	}
}
