package com.javacodegeeks.basics.stringtofloat;

public class StringToFloatClass {

	public static void main(String[] args) {
		
		String s1 = "1.23456f";
		String s2 = "-2";
		
		try {
			// use of constructor
			Float f1 = new Float("0.123456789012");
			System.out.println("f1 = "+f1.floatValue());
			
			float f2 = Float.valueOf(s1).floatValue();
			System.out.println("f2 = "+f2);
			
			// use of signed number
			float f3 = Float.parseFloat(s2);
			System.out.println("f3 = "+f3);
			
			// parseFloat and valueOf operations return the same result value
			float f4 = Float.parseFloat(s1);
			System.out.println("Comparing f2=f4: result = "+(f2==f4));
			
		} catch(NumberFormatException ex) {
			System.err.println("NumberFormatException "+ ex.getMessage());
		} catch(NullPointerException ex) {
			System.err.println("NullPointerException "+ ex.getMessage());
		}
		
	}

}
