package com.javacodegeeks.basics.stringtodate;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class StringToDateClass {

	public static void main(String[] args) {
		String dateString1 = "05-Jun-2014";
		String dateString2 = "Thu 05/06/2014, 4 pm";
		String dateString3 = "2014 05:12:16 EDT";
		Date date = null;
		
		ParsePosition pos = new ParsePosition(4);
		// use of locale
	    DateFormat format1 = new SimpleDateFormat("dd-MMM-yyyy", Locale.ENGLISH);
	    // use of am/pm metric
	    DateFormat format2 = new SimpleDateFormat("dd/MM/yyyy, hh a");
	    // use of hour and timezone
	    DateFormat format3 = new SimpleDateFormat("yyyy HH:mm:ss zzz");
	    // MEDIUM format: "MMM dd, yyyy"
	    DateFormat format4 = DateFormat.getDateInstance(DateFormat.MEDIUM);
	    
	    try {
			date = format1.parse(dateString1);
			System.out.println("Date of dateString1 = " + date);
			
			// the parsing starts from the specified (pos) index
			date = format2.parse(dateString2, pos);
			System.out.println("Date of dateString2 = " + date);
			
			date = format3.parse(dateString3);
			System.out.println("Date of dateString3 = " + date);
			
			date = format4.parse("Jun 05, 2014");
			System.out.println("Date with DateFormat = " + date);
			
			// throws exception
			date = format2.parse(dateString2);

		} catch (ParseException e) {
			e.printStackTrace();
		} catch (NullPointerException e) {
			e.printStackTrace();
		}

	}

}
