package com.javacodegeeks.example;

import java.util.*;

public class BackwardSortExample {

	public static void main(String[] args) {
		ArrayList<Integer> randInts = new ArrayList<>();
		Random rnd = new Random();

		//generate 5 random ints for randInts
		for (int i=0;i<5;i++) {
			randInts.add(rnd.nextInt());
		}

		//show the unordered randInts
		printList(randInts);

		//sort the randInts ArrayList
		Collections.sort(randInts, new Comparator<Integer>() {

			@Override
			public int compare(Integer o1, Integer o2) {
				return (o2.intValue() > o1.intValue()) ? 1 : -1;
			}
			
		});

		//show the ordered randInts
		printList(randInts);
	}

	public static void printList(List<Integer> l) {
		System.out.print("[ ");
		for (int i=0;i<l.size();i++) {
			System.out.print(l.get(i)+" ");
		}
		System.out.println("]");
	}
}
