package com.javacodegeeks.traning.HibernateToolsPlugin;

import java.util.ArrayList;
import java.util.List;

import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;

import com.javacodegeeks.training.pojo.Employee;

public class TestHibernate {
	private static SessionFactory factory;
	private static ServiceRegistry serviceRegistry;

	public static void main(String[] args) {
		Configuration configuration = new Configuration();
		configuration.configure();
		configuration.addAnnotatedClass(Employee.class);
		serviceRegistry = new StandardServiceRegistryBuilder().applySettings(
				configuration.getProperties()).build();
		
		factory = configuration.buildSessionFactory(serviceRegistry);
		TestHibernate testWorker = new TestHibernate();
		testWorker.addEmployee(3, "JavaCodeGeeks", 401);
		
		List<Employee> allEmployees = testWorker.getAllEmployees();
		for(Employee emp : allEmployees){
			System.out.print(emp.getEmployeeId() + "  ");
			System.out.print(emp.getEmployeeName() + "  ");
			System.out.print(emp.getDeptId() + "  ");
			System.out.println();
		}
		
	}

	private int addEmployee(int empId, String empName, int deptId) {
		Session session = factory.openSession();
		Transaction tx = null;
		Integer empIdSaved = null;
		try {
			tx = session.beginTransaction();
			Employee emp = new Employee(empId, empName, deptId);
			empIdSaved = (Integer) session.save(emp);
			tx.commit();
		} catch (HibernateException e) {
			if (tx != null)
				tx.rollback();
			e.printStackTrace();
		} finally {
			session.close();
		}
		return empIdSaved;
	}
	
	@SuppressWarnings("unchecked")
	private List<Employee>  getAllEmployees(){
		Session session = factory.openSession();
		Transaction tx = null;
		List<Employee> employees = new ArrayList<Employee>();
		try {
			tx = session.beginTransaction();
			employees = (List<Employee>)session.createQuery("FROM Employee").list(); 
			tx.commit();
		} catch (HibernateException e) {
			if (tx != null)
				tx.rollback();
			e.printStackTrace();
		} finally {
			session.close();
		}
		return employees;
	}

}
