package com.javacodegeeks.example;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;

/**
 * 
 * @author anirudh
 *
 */
public class JavaStreamTokenizerExample {

	public static void main(String[] args) throws IOException {
		
		//Read from a string
		Reader reader = new StringReader("This is a test string for JCG Stream Tokenizer Example");
		StreamTokenizer tokenizer = new StreamTokenizer(reader);
		while(tokenizer.nextToken()!=StreamTokenizer.TT_EOF){
			System.out.println(tokenizer.sval);
		}
		
		//Read from a file
		FileReader fileReader = new FileReader("/Users/anirudh/test.txt");
		StreamTokenizer filetokenizer = new StreamTokenizer(fileReader);
		while(filetokenizer.nextToken()!=StreamTokenizer.TT_EOF){
			if(filetokenizer.ttype==StreamTokenizer.TT_NUMBER){
				System.out.println(filetokenizer.nval);
			}else if(filetokenizer.ttype==StreamTokenizer.TT_WORD){
				System.out.println(filetokenizer.sval);
			}
		}
	}
}
