package com.javacodegeeks.androidcursorexample;

import java.util.ArrayList;
import java.util.List;

import android.app.ListActivity;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Bundle;
import android.widget.ArrayAdapter;
import android.widget.Toast;

public class AndroidCursorExample extends ListActivity {

	private List<String> bookTitles;
	// DB name
	private final String dbName = "Android";
	private static SQLiteDatabase sqliteDB = null;
	private ArrayAdapter<String> myAdapter;

	// this is the table name
	private final String tableName = "BestSellers";

	// this is the bookTitle Array that will be entered in our SQLite Table
	private final String[] bookTitle = new String[] { "The Great Gatsby", "The Grapes of Wrath", "Invisible Man", "Gone with the Wind", "Pride and Prejudice", "Wuthering Heights", "The Color Purple", "Midnights Children", "Mrs Dalloway", "War and Peace" };

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		// set our main layout
		setContentView(R.layout.activity_main);

		// set the ArrayAdapter for the result list
		bookTitles = new ArrayList<String>();
		myAdapter = new ArrayAdapter<String>(this, R.layout.row_layout, R.id.listText, bookTitles);
		ArrayList<String> results = new ArrayList<String>();

		// Declare SQLiteDatabase object
		sqliteDB = null;

		try {
			// open or create the sqlite database
			sqliteDB = this.openOrCreateDatabase(dbName, MODE_PRIVATE, null);
			// execute the query
			sqliteDB.execSQL("CREATE TABLE IF NOT EXISTS " + tableName + " (bookTitle VARCHAR);");
			// insert bookTitle Array versions into table created
			for (String ver : bookTitle) {
				sqliteDB.execSQL("INSERT INTO " + tableName + " Values ('" + ver + "');");
			}

			// create Cursor in order to parse our sqlite results
			Cursor cursor = sqliteDB.rawQuery("SELECT bookTitle FROM " + tableName, null);
			// if Cursor is contains results
			if (cursor != null) {
				// move cursor to first row
				if (cursor.moveToFirst()) {
					do {
						// Get version from Cursor
						String bookName = cursor.getString(cursor.getColumnIndex("bookTitle"));

						// add the bookName into the bookTitles ArrayList
						bookTitles.add(bookName);
						// move to next row
					} while (cursor.moveToNext());
				}
			}
			// initiate the listadapter
			myAdapter = new ArrayAdapter<String>(this, R.layout.row_layout, R.id.listText, bookTitles);

			// assign the list adapter
			setListAdapter(myAdapter);

		} catch (SQLiteException se) {
			Toast.makeText(getApplicationContext(), "Error creating the database", Toast.LENGTH_LONG).show();
		} finally {
			if (sqliteDB != null) {
				sqliteDB.execSQL("DELETE FROM " + tableName);
				sqliteDB.close();
			}
		}

	}
}
