package com.javacodegeeks.examples;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class CatchExceptionExample {
	
	private static final String HOST = "jdbc:mysql://localhost/";
	private static final String DB = "db_test";
	private static final String USER = "root";
	private static final String PASSWORD = "bitnami";
	
	public static void main(String[] args) {
		String sqlQuery = "INSERT INTO `tbl` (`id`, `name`, `surname`, `age`) VALUES (?,?,?,?)";
		
		try {
			Class.forName("com.mysql.jdbc.Driver");
			Connection conn = DriverManager.getConnection(HOST+DB,USER,PASSWORD);
			PreparedStatement ps = conn.prepareStatement(sqlQuery);
			
			ps.setInt(1,6);
			ps.setString(2, "Name1");
			ps.setString(3, "Surname1");
			ps.setInt(4, 1);
			ps.addBatch();
			
			ps.setInt(1,1);
			ps.setString(2, "Name1");
			ps.setString(3, "Surname1");
			ps.setInt(4, 1);
			ps.addBatch();
			
			int[] affectedRecords = ps.executeBatch();
			
		} catch (BatchUpdateException ex) {
			int[] updateCount = ex.getUpdateCounts();
			
			int count = 1;
			for (int i : updateCount) {
				if  (i == Statement.EXECUTE_FAILED) {
					System.out.println("Error on request " + count +": Execute failed");
				} else {
					System.out.println("Request " + count +": OK");
				}
				count++;
				
			}
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		} catch (SQLException e) {
			e.printStackTrace();
		}
	}
}
