package com.javacodegeeks.snippets.core;

import java.lang.reflect.Array;

public class ArrayExample {

	private static String[] strArr = (String[]) Array.newInstance(String.class, 10);
	private static int[] intArr = (int[]) Array.newInstance(int.class, 10);
	
	public static void fillArrays() {
		for(int i=0; i<=9; i++){
			Array.set(strArr, i, String.valueOf(i));
			Array.setInt(intArr, i, i);
		}
	}
	
	public static void showArrays() {
		System.out.println("-Arrays have: ");
		for(int i=0; i<=9; i++){
			System.out.println("At position " + i + " strArr component is :" + Array.get(strArr, i));
			System.out.println("At position " + i + " intArr component is :" + Array.getInt(intArr, i));
		}
	}
		
	public static void main(String[] args) {
		fillArrays();
		showArrays();
		System.out.println("Components of the strArr are of type : " + strArr.getClass().getComponentType());
		System.out.println("Length of the strArr is : " + Array.getLength(strArr));
		System.out.println("Components of the intArr are of type : " + intArr.getClass().getComponentType());
		System.out.println("Length of the intArr is : " + Array.getLength(strArr));
	}
}