package com.jcg.examples;


import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;


public class URLClassLoaderDemo
{
		public static void main(String[] args) throws MalformedURLException
		{
				List<URL> urls = new ArrayList<>();
				urls.add(new URL("file:\\C:\\Users\\CENTAUR\\Desktop\\jcg.jar"));

				try (URLClassLoader urlClassLoader = new URLClassLoader(urls.toArray(new URL[urls.size()])))
				{
						//Loading the class
						Class<?> simpleClass = urlClassLoader.loadClass("com.jcg.examples.JavaPoJo");

						//accessing the constructor to instantiate the class
						Constructor<?> simpleConstructor = simpleClass.getConstructor();

						//instantiating the class
						Object simpleClassObj = simpleConstructor.newInstance();

						//accessing an instance method
						Method method = simpleClass.getMethod("foo");

						//invoking the method..
						method.invoke(simpleClassObj);


				}
				catch (Exception e)
				{
						e.printStackTrace();
				}
		}
}
