/*
 * Decompiled with CFR 0.152.
 */
package javax.faces;

import com.sun.faces.spi.InjectionProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.TypedCollections;
import javax.faces.application.ApplicationFactory;
import javax.faces.component.visit.VisitContextFactory;
import javax.faces.context.ExceptionHandlerFactory;
import javax.faces.context.ExternalContextFactory;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.context.FlashFactory;
import javax.faces.context.PartialViewContextFactory;
import javax.faces.flow.FlowHandlerFactory;
import javax.faces.lifecycle.ClientWindowFactory;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKitFactory;
import javax.faces.view.ViewDeclarationLanguageFactory;
import javax.faces.view.facelets.FaceletCacheFactory;
import javax.faces.view.facelets.TagHandlerDelegateFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FactoryFinderInstance {
    private final Map<String, Object> factories;
    private final Map<String, List<String>> savedFactoryNames;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    private static final String INJECTION_PROVIDER_KEY = FactoryFinder.class.getPackage().getName() + "INJECTION_PROVIDER_KEY";
    private static final String[] FACTORY_NAMES;
    private static final Map<String, Class> FACTORY_CLASSES;
    private static final Logger LOGGER;

    FactoryFinderInstance() {
        this.factories = new HashMap<String, Object>();
        this.savedFactoryNames = new HashMap<String, List<String>>();
        for (String string : FACTORY_NAMES) {
            this.factories.put(string, new ArrayList(4));
        }
        this.copyInjectionProviderFromFacesContext();
    }

    FactoryFinderInstance(FactoryFinderInstance factoryFinderInstance) {
        this.factories = new HashMap<String, Object>();
        this.savedFactoryNames = new HashMap<String, List<String>>();
        this.factories.putAll(factoryFinderInstance.savedFactoryNames);
        this.copyInjectionProviderFromFacesContext();
    }

    private void copyInjectionProviderFromFacesContext() {
        InjectionProvider injectionProvider = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (null != facesContext) {
            injectionProvider = (InjectionProvider)facesContext.getAttributes().get("com.sun.faces.config.ConfigManager_INJECTION_PROVIDER_TASK");
        }
        if (null != injectionProvider) {
            this.factories.put(INJECTION_PROVIDER_KEY, injectionProvider);
        } else if (LOGGER.isLoggable(Level.SEVERE)) {
            LOGGER.log(Level.SEVERE, "Unable to obtain InjectionProvider from init time FacesContext. Does this container implement the Mojarra Injection SPI?");
        }
    }

    private Object getImplementationInstance(ClassLoader classLoader, String string, List list) throws FacesException {
        List<String> list2;
        String string2;
        int n;
        Object object = null;
        if (null != list && (1 < (n = list.size()) || 1 == n)) {
            string2 = (String)list.remove(n - 1);
            object = this.getImplGivenPreviousImpl(classLoader, string, string2, null);
        }
        if ((list2 = this.getImplNameFromServices(classLoader, string)) != null) {
            for (String string3 : list2) {
                object = this.getImplGivenPreviousImpl(classLoader, string, string3, object);
            }
        }
        if (null != list) {
            for (n = list.size() - 1; 0 <= n; --n) {
                string2 = (String)list.remove(n);
                object = this.getImplGivenPreviousImpl(classLoader, string, string2, object);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getImplNameFromServices(ClassLoader classLoader, String string) {
        ArrayList<String> arrayList;
        block12: {
            arrayList = null;
            String string2 = "META-INF/services/" + string;
            BufferedReader bufferedReader = null;
            try {
                Enumeration<URL> enumeration = classLoader.getResources(string2);
                while (enumeration.hasMoreElements()) {
                    URL uRL = enumeration.nextElement();
                    URLConnection uRLConnection = uRL.openConnection();
                    uRLConnection.setUseCaches(false);
                    InputStream inputStream = uRLConnection.getInputStream();
                    if (inputStream == null) continue;
                    try {
                        bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                        if (arrayList == null) {
                            arrayList = new ArrayList<String>(3);
                        }
                        arrayList.add(bufferedReader.readLine());
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    }
                    finally {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                            bufferedReader = null;
                        }
                        if (inputStream == null) continue;
                        inputStream.close();
                        inputStream = null;
                    }
                }
            }
            catch (IOException iOException) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, iOException.toString(), iOException);
                }
            }
            catch (SecurityException securityException) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block12;
                LOGGER.log(Level.SEVERE, securityException.toString(), securityException);
            }
        }
        return arrayList;
    }

    private Object getImplGivenPreviousImpl(ClassLoader classLoader, String string, String string2, Object object) {
        Class<?> clazz;
        Class clazz2 = null;
        Object[] objectArray = new Object[1];
        Object var10_7 = null;
        if (null != object && null != (clazz2 = this.getFactoryClass(string))) {
            try {
                clazz = Class.forName(string2, false, classLoader);
                Class[] classArray = new Class[]{clazz2};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                objectArray[0] = object;
                var10_7 = constructor.newInstance(objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                clazz2 = null;
            }
            catch (Exception exception) {
                throw new FacesException(string2, exception);
            }
        }
        if (null == object || null == clazz2) {
            try {
                clazz = Class.forName(string2, false, classLoader);
                var10_7 = clazz.newInstance();
            }
            catch (Exception exception) {
                throw new FacesException(string2, exception);
            }
        }
        if (null != var10_7) {
            InjectionProvider injectionProvider = this.getInjectionProvider();
            if (null != injectionProvider) {
                try {
                    injectionProvider.inject(var10_7);
                    injectionProvider.invokePostConstruct(var10_7);
                }
                catch (Exception exception) {
                    throw new FacesException(string2, exception);
                }
            } else if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "Unable to inject {0} because no InjectionProvider can be found. Does this container implement the Mojarra Injection SPI?", (Object)var10_7);
            }
        }
        return var10_7;
    }

    private Class getFactoryClass(String string) {
        return FACTORY_CLASSES.get(string);
    }

    Collection<Object> getFactories() {
        return this.factories.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFactory(String string, String string2) {
        this.validateFactoryName(string);
        Object object = this.factories.get(string);
        this.lock.writeLock().lock();
        try {
            if (object instanceof List) {
                TypedCollections.dynamicallyCastList((List)object, String.class).add(0, string2);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseFactories() {
        InjectionProvider injectionProvider = this.getInjectionProvider();
        if (null != injectionProvider) {
            this.lock.writeLock().lock();
            try {
                for (Map.Entry<String, Object> entry : this.factories.entrySet()) {
                    Object object = entry.getValue();
                    if (INJECTION_PROVIDER_KEY.equals(entry.getKey()) || null == object || object instanceof String) continue;
                    try {
                        injectionProvider.invokePreDestroy(object);
                    }
                    catch (Exception exception) {
                        if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                        String string = MessageFormat.format("Unable to invoke @PreDestroy annotated methods on {0}.", entry.getValue());
                        LOGGER.log(Level.SEVERE, string, exception);
                    }
                }
            }
            finally {
                this.factories.clear();
                this.lock.writeLock().unlock();
            }
        } else if (LOGGER.isLoggable(Level.SEVERE)) {
            LOGGER.log(Level.SEVERE, "Unable to call @PreDestroy annotated methods because no InjectionProvider can be found. Does this container implement the Mojarra Injection SPI?");
        }
    }

    InjectionProvider getInjectionProvider() {
        InjectionProvider injectionProvider = (InjectionProvider)this.factories.get(INJECTION_PROVIDER_KEY);
        return injectionProvider;
    }

    void clearInjectionProvider() {
        this.factories.remove(INJECTION_PROVIDER_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getFactory(String string) {
        Object object;
        this.validateFactoryName(string);
        this.lock.readLock().lock();
        try {
            object = this.factories.get(string);
            if (!(object instanceof List)) {
                Object object2 = object;
                return object2;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            Object object3;
            object = this.factories.get(string);
            if (!(object instanceof List)) {
                Object object4 = object;
                return object4;
            }
            this.savedFactoryNames.put(string, new ArrayList((List)object));
            ClassLoader classLoader = this.getClassLoader();
            Object object5 = this.getImplementationInstance(classLoader, string, (List)object);
            if (object5 == null) {
                object3 = LOGGER.getResourceBundle();
                String string2 = ((ResourceBundle)object3).getString("severe.no_factory");
                string2 = MessageFormat.format(string2, string);
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, string2);
                }
                if (null == (object5 = FactoryFinder.FACTORIES_CACHE.getFallbackFactory(this, string))) {
                    string2 = ((ResourceBundle)object3).getString("severe.no_factory_backup_failed");
                    string2 = MessageFormat.format(string2, string);
                    throw new IllegalStateException(string2);
                }
            }
            this.factories.put(string, object5);
            object3 = object5;
            return object3;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private ClassLoader getClassLoader() throws FacesException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            throw new FacesException("getContextClassLoader");
        }
        return classLoader;
    }

    private void validateFactoryName(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (Arrays.binarySearch(FACTORY_NAMES, string) < 0) {
            throw new IllegalArgumentException(string);
        }
    }

    static {
        HashMap<String, Class> hashMap = new HashMap<String, Class>();
        hashMap.put("javax.faces.application.ApplicationFactory", ApplicationFactory.class);
        hashMap.put("javax.faces.component.visit.VisitContextFactory", VisitContextFactory.class);
        hashMap.put("javax.faces.context.ExceptionHandlerFactory", ExceptionHandlerFactory.class);
        hashMap.put("javax.faces.context.ExternalContextFactory", ExternalContextFactory.class);
        hashMap.put("javax.faces.context.FacesContextFactory", FacesContextFactory.class);
        hashMap.put("javax.faces.context.FlashFactory", FlashFactory.class);
        hashMap.put("javax.faces.context.PartialViewContextFactory", PartialViewContextFactory.class);
        hashMap.put("javax.faces.lifecycle.LifecycleFactory", LifecycleFactory.class);
        hashMap.put("javax.faces.lifecycle.ClientWindowFactory", ClientWindowFactory.class);
        hashMap.put("javax.faces.render.RenderKitFactory", RenderKitFactory.class);
        hashMap.put("javax.faces.view.ViewDeclarationLanguageFactory", ViewDeclarationLanguageFactory.class);
        hashMap.put("javax.faces.view.facelets.FaceletCacheFactory", FaceletCacheFactory.class);
        hashMap.put("javax.faces.view.facelets.TagHandlerDelegateFactory", TagHandlerDelegateFactory.class);
        hashMap.put("javax.faces.flow.FlowHandlerFactory", FlowHandlerFactory.class);
        FACTORY_CLASSES = Collections.unmodifiableMap(hashMap);
        FACTORY_NAMES = new String[]{"javax.faces.application.ApplicationFactory", "javax.faces.component.visit.VisitContextFactory", "javax.faces.context.ExceptionHandlerFactory", "javax.faces.context.ExternalContextFactory", "javax.faces.context.FacesContextFactory", "javax.faces.context.FlashFactory", "javax.faces.flow.FlowHandlerFactory", "javax.faces.context.PartialViewContextFactory", "javax.faces.lifecycle.ClientWindowFactory", "javax.faces.lifecycle.LifecycleFactory", "javax.faces.render.RenderKitFactory", "javax.faces.view.ViewDeclarationLanguageFactory", "javax.faces.view.facelets.FaceletCacheFactory", "javax.faces.view.facelets.TagHandlerDelegateFactory"};
        Arrays.sort(FACTORY_NAMES);
        LOGGER = Logger.getLogger("javax.faces", "javax.faces.LogStrings");
    }
}

