/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.MessageFactory;

public class ByteConverter
implements Converter {
    public static final String CONVERTER_ID = "javax.faces.Byte";
    public static final String BYTE_ID = "javax.faces.converter.ByteConverter.BYTE";
    public static final String STRING_ID = "javax.faces.converter.STRING";

    public Object getAsObject(FacesContext facesContext, UIComponent uIComponent, String string) {
        if (facesContext == null || uIComponent == null) {
            throw new NullPointerException();
        }
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() < 1) {
            return null;
        }
        try {
            return Byte.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConverterException(MessageFactory.getMessage(facesContext, BYTE_ID, string, "254", MessageFactory.getLabel(facesContext, uIComponent)), (Throwable)numberFormatException);
        }
        catch (Exception exception) {
            throw new ConverterException(exception);
        }
    }

    public String getAsString(FacesContext facesContext, UIComponent uIComponent, Object object) {
        if (facesContext == null || uIComponent == null) {
            throw new NullPointerException();
        }
        if (object == null) {
            return "";
        }
        if (object instanceof String) {
            return (String)object;
        }
        try {
            return Byte.toString((Byte)object);
        }
        catch (Exception exception) {
            throw new ConverterException(MessageFactory.getMessage(facesContext, STRING_ID, object, MessageFactory.getLabel(facesContext, uIComponent)), (Throwable)exception);
        }
    }
}

