/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.util.FacesLogger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;

public final class Resource {
    protected static final Logger log = FacesLogger.FACELETS_FACTORY.getLogger();

    static URL getResourceUrl(FacesContext facesContext, String string) throws MalformedURLException {
        ExternalContext externalContext = facesContext.getExternalContext();
        URL uRL = externalContext.getResource(string);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Resource-Url from external context: " + uRL);
        }
        if (uRL == null && Resource.resourceExist(externalContext, string)) {
            uRL = Resource.getUrlForResourceAsStream(externalContext, string);
        }
        return uRL;
    }

    private static boolean resourceExist(ExternalContext externalContext, String string) {
        ServletContext servletContext;
        InputStream inputStream;
        if ("/".equals(string)) {
            return true;
        }
        Object object = externalContext.getContext();
        if (object instanceof ServletContext && (inputStream = (servletContext = (ServletContext)object).getResourceAsStream(string)) != null) {
            block4: {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    if (!log.isLoggable(Level.FINEST)) break block4;
                    log.log(Level.FINEST, "Closing stream", iOException);
                }
            }
            return true;
        }
        return false;
    }

    private static URL getUrlForResourceAsStream(final ExternalContext externalContext, String string) throws MalformedURLException {
        URLStreamHandler uRLStreamHandler = new URLStreamHandler(){

            protected URLConnection openConnection(URL uRL) throws IOException {
                final String string = uRL.getFile();
                return new URLConnection(uRL){

                    public void connect() throws IOException {
                    }

                    public InputStream getInputStream() throws IOException {
                        Object object;
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Opening internal url to " + string);
                        }
                        if ((object = externalContext.getContext()) instanceof ServletContext) {
                            ServletContext servletContext = (ServletContext)object;
                            InputStream inputStream = servletContext.getResourceAsStream(string);
                            if (inputStream == null) {
                                throw new FileNotFoundException("Cannot open resource " + string);
                            }
                            return inputStream;
                        }
                        throw new IOException("Cannot open resource for an context of " + (object != null ? object.getClass() : null));
                    }
                };
            }
        };
        return new URL("internal", null, 0, string, uRLStreamHandler);
    }
}

