/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.view.FaceletViewHandlingStrategy;
import com.sun.faces.application.view.JspViewHandlingStrategy;
import com.sun.faces.application.view.ViewHandlingStrategy;
import com.sun.faces.application.view.ViewHandlingStrategyNotFoundException;
import com.sun.faces.config.WebConfiguration;

public class ViewHandlingStrategyManager {
    private volatile ViewHandlingStrategy[] strategies;

    public ViewHandlingStrategyManager() {
        ViewHandlingStrategy[] viewHandlingStrategyArray;
        WebConfiguration webConfiguration = WebConfiguration.getInstance();
        boolean bl = webConfiguration.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.DisableFaceletJSFViewHandler);
        if (bl) {
            ViewHandlingStrategy[] viewHandlingStrategyArray2 = new ViewHandlingStrategy[1];
            viewHandlingStrategyArray = viewHandlingStrategyArray2;
            viewHandlingStrategyArray2[0] = new JspViewHandlingStrategy();
        } else {
            ViewHandlingStrategy[] viewHandlingStrategyArray3 = new ViewHandlingStrategy[2];
            viewHandlingStrategyArray3[0] = new FaceletViewHandlingStrategy();
            viewHandlingStrategyArray = viewHandlingStrategyArray3;
            viewHandlingStrategyArray3[1] = new JspViewHandlingStrategy();
        }
        this.strategies = viewHandlingStrategyArray;
    }

    public ViewHandlingStrategy getStrategy(String string) {
        for (ViewHandlingStrategy viewHandlingStrategy : this.strategies) {
            if (!viewHandlingStrategy.handlesViewId(string)) continue;
            return viewHandlingStrategy;
        }
        throw new ViewHandlingStrategyNotFoundException();
    }

    public ViewHandlingStrategy[] getViewHandlingStrategies() {
        return (ViewHandlingStrategy[])this.strategies.clone();
    }

    public synchronized void setViewHandlingStrategies(ViewHandlingStrategy[] viewHandlingStrategyArray) {
        this.strategies = (ViewHandlingStrategy[])viewHandlingStrategyArray.clone();
    }
}

