/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.view.ViewScopeManager;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewScoped;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewScopeContext
implements Context,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(ViewScopeContext.class.getName());
    private static final long serialVersionUID = -6245899073989073951L;

    public ViewScopeContext() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Creating ViewScope CDI context");
        }
    }

    private final void assertNotReleased() {
        if (!this.isActive()) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "Trying to access ViewScope CDI context while it is not active");
            }
            throw new ContextNotActiveException();
        }
    }

    public <T> T get(Contextual<T> contextual) {
        ViewScopeManager viewScopeManager;
        this.assertNotReleased();
        T t = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null && (viewScopeManager = ViewScopeManager.getInstance(facesContext)) != null) {
            t = viewScopeManager.getContextManager().getBean(facesContext, contextual);
        }
        return t;
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        ViewScopeManager viewScopeManager;
        FacesContext facesContext;
        this.assertNotReleased();
        T t = this.get(contextual);
        if (t == null && (facesContext = FacesContext.getCurrentInstance()) != null && (t = (viewScopeManager = ViewScopeManager.getInstance(facesContext)).getContextManager().getBean(facesContext, contextual)) == null) {
            t = viewScopeManager.getContextManager().createBean(facesContext, contextual, creationalContext);
        }
        return t;
    }

    public Class<? extends Annotation> getScope() {
        return ViewScoped.class;
    }

    public boolean isActive() {
        UIViewRoot uIViewRoot;
        boolean bl = false;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null && (uIViewRoot = facesContext.getViewRoot()) != null) {
            bl = true;
        }
        return bl;
    }
}

