/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.config.DocumentInfo;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.util.FacesLogger;
import java.text.MessageFormat;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FacesConfigExtensionProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String FACES_CONFIG_EXTENSION = "faces-config-extension";
    private static final String FACELETS_PROCESSING = "facelets-processing";
    private static final String FILE_EXTENSION = "file-extension";
    private static final String PROCESS_AS = "process-as";

    public void process(ServletContext servletContext, DocumentInfo[] documentInfoArray) throws Exception {
        for (int i = 0; i < documentInfoArray.length; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing faces-config-extension elements for document: ''{0}''", documentInfoArray[i].getSourceURI()));
            }
            Document document = documentInfoArray[i].getDocument();
            String string = document.getDocumentElement().getNamespaceURI();
            NodeList nodeList = document.getDocumentElement().getElementsByTagNameNS(string, FACES_CONFIG_EXTENSION);
            if (nodeList == null || nodeList.getLength() <= 0) continue;
            this.processFacesConfigExtensions(nodeList, string, documentInfoArray[i]);
        }
        this.invokeNext(servletContext, documentInfoArray);
    }

    private void processFacesConfigExtensions(NodeList nodeList, String string, DocumentInfo documentInfo) {
        WebConfiguration webConfiguration = null;
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            NodeList nodeList2 = ((Element)node).getElementsByTagNameNS(string, "*");
            int n2 = nodeList2.getLength();
            for (int j = 0; j < n2; ++j) {
                Node node2 = nodeList2.item(j);
                if (!FACELETS_PROCESSING.equals(node2.getLocalName())) continue;
                Node node3 = node2;
                NodeList nodeList3 = ((Element)node3).getElementsByTagNameNS(string, "*");
                String string2 = null;
                String string3 = null;
                int n3 = nodeList3.getLength();
                for (int k = 0; k < n3; ++k) {
                    Node node4 = nodeList3.item(k);
                    if (null == string2 && FILE_EXTENSION.equals(node4.getLocalName())) {
                        string2 = this.getNodeText(node4);
                        continue;
                    }
                    if (null == string3 && PROCESS_AS.equals(node4.getLocalName())) {
                        string3 = this.getNodeText(node4);
                        continue;
                    }
                    if (!LOGGER.isLoggable(Level.WARNING)) continue;
                    LOGGER.log(Level.WARNING, MessageFormat.format("Processing faces-config-extension elements for document: ''{0}'', encountered unexpected configuration ''{1}'', ignoring and continuing", documentInfo.getSourceURI(), this.getNodeText(node4)));
                }
                if (null != string2 && null != string3) {
                    if (null == webConfiguration) {
                        webConfiguration = WebConfiguration.getInstance();
                    }
                    Map<String, String> map = webConfiguration.getFacesConfigOptionValue(WebConfiguration.WebContextInitParameter.FaceletsProcessingFileExtensionProcessAs, true);
                    map.put(string2, string3);
                    continue;
                }
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, MessageFormat.format("Processing faces-config-extension elements for document: ''{0}'', encountered <facelets-processing> elemnet without expected children", documentInfo.getSourceURI()));
            }
        }
    }
}

