/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.config.DocumentInfo;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.util.FacesLogger;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FactoryFinder;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.ServletContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LifecycleConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String LIFECYCLE = "lifecycle";
    private static final String PHASE_LISTENER = "phase-listener";
    private List<PhaseListener> appPhaseListeners = new CopyOnWriteArrayList<PhaseListener>();

    public void destroy(ServletContext servletContext) {
        this.destroyInstances(servletContext, this.appPhaseListeners);
        this.destroyNext(servletContext);
    }

    private void destroyInstances(ServletContext servletContext, List list) {
        for (Object e : list) {
            this.destroyInstance(servletContext, e.getClass().getName(), e);
        }
        list.clear();
    }

    public void process(ServletContext servletContext, DocumentInfo[] documentInfoArray) throws Exception {
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        for (int i = 0; i < documentInfoArray.length; ++i) {
            String string;
            Document document;
            NodeList nodeList;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing lifecycle elements for document: ''{0}''", documentInfoArray[i].getSourceURI()));
            }
            if ((nodeList = (document = documentInfoArray[i].getDocument()).getElementsByTagNameNS(string = document.getDocumentElement().getNamespaceURI(), LIFECYCLE)) == null) continue;
            int n = nodeList.getLength();
            for (int j = 0; j < n; ++j) {
                Node node = nodeList.item(j);
                if (node.getNodeType() != 1) continue;
                NodeList nodeList2 = ((Element)node).getElementsByTagNameNS(string, PHASE_LISTENER);
                this.addPhaseListeners(servletContext, lifecycleFactory, nodeList2);
            }
        }
        this.invokeNext(servletContext, documentInfoArray);
    }

    private void addPhaseListeners(ServletContext servletContext, LifecycleFactory lifecycleFactory, NodeList nodeList) {
        if (nodeList != null && nodeList.getLength() > 0) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                boolean[] blArray;
                PhaseListener phaseListener;
                Node node = nodeList.item(i);
                String string = this.getNodeText(node);
                if (string == null || (phaseListener = (PhaseListener)this.createInstance(servletContext, string, PhaseListener.class, null, node, true, blArray = new boolean[]{false})) == null) continue;
                if (blArray[0]) {
                    this.appPhaseListeners.add(phaseListener);
                }
                Iterator iterator = lifecycleFactory.getLifecycleIds();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    Lifecycle lifecycle = lifecycleFactory.getLifecycle(string2);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, MessageFormat.format("Adding PhaseListener ''{0}'' to lifecycle ''{0}}", string, string2));
                    }
                    lifecycle.addPhaseListener(phaseListener);
                }
            }
        }
    }
}

