/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseContextMap<V>
extends AbstractMap<String, V> {
    private Set<Map.Entry<String, V>> entrySet;
    private Set<String> keySet;
    private Collection<V> values;

    BaseContextMap() {
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public Set<String> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new ValueCollection();
        }
        return this.values;
    }

    @Override
    public V remove(Object object) {
        throw new UnsupportedOperationException();
    }

    protected boolean removeKey(Object object) {
        return this.remove(object) != null;
    }

    protected boolean removeValue(Object object) {
        boolean bl = false;
        if (object == null) {
            return false;
        }
        if (this.containsValue(object)) {
            for (Map.Entry<String, V> entry : this.entrySet()) {
                if (!object.equals(entry.getValue())) continue;
                bl = this.remove(entry.getKey()) != null;
            }
        }
        return bl;
    }

    protected abstract Iterator<Map.Entry<String, V>> getEntryIterator();

    protected abstract Iterator<String> getKeyIterator();

    protected abstract Iterator<V> getValueIterator();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Entry<V>
    implements Map.Entry<String, V> {
        private final String key;
        private final V value;

        Entry(String string, V v) {
            this.key = string;
            this.value = v;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        @Override
        public boolean equals(Object object) {
            if (object == null || !(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k = entry.getKey();
            Object v = entry.getValue();
            return (k == this.key || k != null && k.equals(this.key)) && (v == this.value || v != null && v.equals(this.value));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ValueIterator
    extends BaseIterator<V> {
        ValueIterator(Enumeration enumeration) {
            super(enumeration);
        }

        @Override
        public void remove() {
            if (this.currentKey == null || this.removeCalled) {
                throw new IllegalStateException();
            }
            this.removeCalled = true;
            BaseContextMap.this.removeValue(BaseContextMap.this.get(this.currentKey));
        }

        @Override
        public V next() {
            this.nextKey();
            return BaseContextMap.this.get(this.currentKey);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class KeyIterator
    extends BaseIterator<String> {
        KeyIterator(Enumeration enumeration) {
            super(enumeration);
        }

        @Override
        public void remove() {
            if (this.currentKey == null || this.removeCalled) {
                throw new IllegalStateException();
            }
            this.removeCalled = true;
            BaseContextMap.this.removeKey(this.currentKey);
        }

        @Override
        public String next() {
            return this.nextKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EntryIterator
    extends BaseIterator<Map.Entry<String, V>> {
        EntryIterator(Enumeration enumeration) {
            super(enumeration);
        }

        @Override
        public void remove() {
            if (this.currentKey == null || this.removeCalled) {
                throw new IllegalStateException();
            }
            this.removeCalled = true;
            BaseContextMap.this.removeKey(this.currentKey);
        }

        @Override
        public Map.Entry<String, V> next() {
            this.nextKey();
            return new Entry(this.currentKey, BaseContextMap.this.get(this.currentKey));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class BaseIterator<E>
    implements Iterator<E> {
        protected Enumeration e;
        protected String currentKey;
        protected boolean removeCalled = false;

        BaseIterator(Enumeration enumeration) {
            this.e = enumeration;
        }

        @Override
        public boolean hasNext() {
            return this.e.hasMoreElements();
        }

        public String nextKey() {
            this.removeCalled = false;
            this.currentKey = (String)this.e.nextElement();
            return this.currentKey;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ValueCollection
    extends AbstractCollection<V> {
        ValueCollection() {
        }

        @Override
        public int size() {
            int n = 0;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                ++n;
            }
            return n;
        }

        @Override
        public Iterator<V> iterator() {
            return BaseContextMap.this.getValueIterator();
        }

        @Override
        public boolean remove(Object object) {
            return BaseContextMap.this.removeValue(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class KeySet
    extends BaseSet<String> {
        KeySet() {
        }

        @Override
        public Iterator<String> iterator() {
            return BaseContextMap.this.getKeyIterator();
        }

        @Override
        public boolean contains(Object object) {
            return BaseContextMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return object instanceof String && BaseContextMap.this.removeKey(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EntrySet
    extends BaseSet<Map.Entry<String, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<String, V>> iterator() {
            return BaseContextMap.this.getEntryIterator();
        }

        @Override
        public boolean remove(Object object) {
            return object instanceof Map.Entry && BaseContextMap.this.removeKey(((Map.Entry)object).getKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class BaseSet<E>
    extends AbstractSet<E> {
        BaseSet() {
        }

        @Override
        public int size() {
            int n = 0;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                ++n;
            }
            return n;
        }
    }
}

