/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.el;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;
import javax.faces.view.facelets.TagAttribute;

public final class TagMethodExpression
extends MethodExpression
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private String attr;
    private MethodExpression orig;

    public TagMethodExpression() {
    }

    public TagMethodExpression(TagAttribute tagAttribute, MethodExpression methodExpression) {
        this.attr = tagAttribute.toString();
        this.orig = methodExpression;
    }

    public MethodInfo getMethodInfo(ELContext eLContext) {
        try {
            return this.orig.getMethodInfo(eLContext);
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            throw new PropertyNotFoundException(this.attr + ": " + propertyNotFoundException.getMessage(), propertyNotFoundException.getCause());
        }
        catch (MethodNotFoundException methodNotFoundException) {
            throw new MethodNotFoundException(this.attr + ": " + methodNotFoundException.getMessage(), methodNotFoundException.getCause());
        }
        catch (ELException eLException) {
            throw new ELException(this.attr + ": " + eLException.getMessage(), eLException.getCause());
        }
    }

    public Object invoke(ELContext eLContext, Object[] objectArray) {
        try {
            return this.orig.invoke(eLContext, objectArray);
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            throw new PropertyNotFoundException(this.attr + ": " + propertyNotFoundException.getMessage(), propertyNotFoundException.getCause());
        }
        catch (MethodNotFoundException methodNotFoundException) {
            throw new MethodNotFoundException(this.attr + ": " + methodNotFoundException.getMessage(), methodNotFoundException.getCause());
        }
        catch (ELException eLException) {
            throw new ELException(this.attr + ": " + eLException.getMessage(), eLException.getCause());
        }
    }

    public String getExpressionString() {
        return this.orig.getExpressionString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TagMethodExpression tagMethodExpression = (TagMethodExpression)object;
        if (this.attr != null ? !this.attr.equals(tagMethodExpression.attr) : tagMethodExpression.attr != null) {
            return false;
        }
        return !(this.orig != null ? !this.orig.equals((Object)tagMethodExpression.orig) : tagMethodExpression.orig != null);
    }

    public int hashCode() {
        int n = this.attr != null ? this.attr.hashCode() : 0;
        n = 31 * n + (this.orig != null ? this.orig.hashCode() : 0);
        return n;
    }

    public boolean isLiteralText() {
        return this.orig.isLiteralText();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.orig);
        objectOutput.writeUTF(this.attr);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.orig = (MethodExpression)objectInput.readObject();
        this.attr = objectInput.readUTF();
    }

    public String toString() {
        return this.attr + ": " + this.orig;
    }
}

