/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.impl;

import com.sun.faces.facelets.impl.DefaultFacelet;
import com.sun.faces.util.ConcurrentCache;
import com.sun.faces.util.ExpiringConcurrentCache;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.view.facelets.FaceletCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DefaultFaceletCache
extends FaceletCache<DefaultFacelet> {
    private static final Logger LOGGER = FacesLogger.FACELETS_FACTORY.getLogger();
    private final ConcurrentCache<URL, Record> _faceletCache;
    private final ConcurrentCache<URL, Record> _metadataFaceletCache;

    DefaultFaceletCache(final long l) {
        final boolean bl = l > 0L;
        ConcurrentCache.Factory<URL, Record> factory = new ConcurrentCache.Factory<URL, Record>(){

            @Override
            public Record newInstance(URL uRL) throws IOException {
                long l2 = bl ? Util.getLastModified(uRL) : 0L;
                return new Record(System.currentTimeMillis(), l2, (DefaultFacelet)DefaultFaceletCache.this.getMemberFactory().newInstance(uRL), l);
            }
        };
        ConcurrentCache.Factory<URL, Record> factory2 = new ConcurrentCache.Factory<URL, Record>(){

            @Override
            public Record newInstance(URL uRL) throws IOException {
                long l2 = bl ? Util.getLastModified(uRL) : 0L;
                return new Record(System.currentTimeMillis(), l2, (DefaultFacelet)DefaultFaceletCache.this.getMetadataMemberFactory().newInstance(uRL), l);
            }
        };
        if (l == 0L) {
            this._faceletCache = new NoCache(factory);
            this._metadataFaceletCache = new NoCache(factory2);
        } else {
            ExpiringConcurrentCache.ExpiryChecker<URL, Record> expiryChecker = l > 0L ? new ExpiryChecker() : new NeverExpired();
            this._faceletCache = new ExpiringConcurrentCache<URL, Record>(factory, expiryChecker);
            this._metadataFaceletCache = new ExpiringConcurrentCache<URL, Record>(factory2, expiryChecker);
        }
    }

    public DefaultFacelet getFacelet(URL uRL) throws IOException {
        Util.notNull("url", uRL);
        DefaultFacelet defaultFacelet = null;
        try {
            defaultFacelet = this._faceletCache.get(uRL).getFacelet();
        }
        catch (ExecutionException executionException) {
            this._unwrapIOException(executionException);
        }
        return defaultFacelet;
    }

    public boolean isFaceletCached(URL uRL) {
        Util.notNull("url", uRL);
        return this._faceletCache.containsKey(uRL);
    }

    public DefaultFacelet getViewMetadataFacelet(URL uRL) throws IOException {
        Util.notNull("url", uRL);
        DefaultFacelet defaultFacelet = null;
        try {
            defaultFacelet = this._metadataFaceletCache.get(uRL).getFacelet();
        }
        catch (ExecutionException executionException) {
            this._unwrapIOException(executionException);
        }
        return defaultFacelet;
    }

    public boolean isViewMetadataFaceletCached(URL uRL) {
        Util.notNull("url", uRL);
        return this._metadataFaceletCache.containsKey(uRL);
    }

    private void _unwrapIOException(ExecutionException executionException) throws IOException {
        Throwable throwable = executionException.getCause();
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        if (throwable.getCause() instanceof IOException) {
            throw (IOException)throwable.getCause();
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new FacesException(throwable);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NoCache
    extends ConcurrentCache<URL, Record> {
        public NoCache(ConcurrentCache.Factory<URL, Record> factory) {
            super(factory);
        }

        @Override
        public Record get(URL uRL) throws ExecutionException {
            try {
                return (Record)this.getFactory().newInstance(uRL);
            }
            catch (Exception exception) {
                throw new ExecutionException(exception);
            }
        }

        @Override
        public boolean containsKey(URL uRL) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NeverExpired
    implements ExpiringConcurrentCache.ExpiryChecker<URL, Record> {
        private NeverExpired() {
        }

        @Override
        public boolean isExpired(URL uRL, Record record) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExpiryChecker
    implements ExpiringConcurrentCache.ExpiryChecker<URL, Record> {
        private ExpiryChecker() {
        }

        @Override
        public boolean isExpired(URL uRL, Record record) {
            long l = record.getNextRefreshTime();
            if (System.currentTimeMillis() > l) {
                long l2 = Util.getLastModified(uRL);
                return l2 > record.getLastModified();
            }
            return false;
        }
    }

    private static class Record {
        private final long _lastModified;
        private final long _refreshInterval;
        private final long _creationTime;
        private final AtomicLong _nextRefreshTime;
        private final DefaultFacelet _facelet;

        Record(long l, long l2, DefaultFacelet defaultFacelet, long l3) {
            this._facelet = defaultFacelet;
            this._creationTime = l;
            this._lastModified = l2;
            this._refreshInterval = l3;
            this._nextRefreshTime = this._refreshInterval > 0L ? new AtomicLong(l + l3) : null;
        }

        DefaultFacelet getFacelet() {
            return this._facelet;
        }

        long getLastModified() {
            return this._lastModified;
        }

        long getNextRefreshTime() {
            return this._refreshInterval > 0L ? this._nextRefreshTime.getAndAdd(this._refreshInterval) : 0L;
        }
    }
}

