/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag;

import com.sun.faces.facelets.tag.TagAttributeImpl;
import com.sun.faces.facelets.tag.TagAttributesImpl;
import java.util.HashMap;
import java.util.Map;
import javax.faces.view.Location;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributes;
import javax.faces.view.facelets.TagDecorator;

class DefaultTagDecorator
implements TagDecorator {
    private ElementConverter defaultElementConverter = new ElementConverter("jsf:element");

    DefaultTagDecorator() {
    }

    public Tag decorate(Tag tag) {
        String string = tag.getNamespace();
        if (!this.hasJsfAttribute(tag)) {
            return null;
        }
        if (!"".equals(string) && !"http://www.w3.org/1999/xhtml".equals(string)) {
            throw new FaceletException("Elements with namespace " + string + " may not have attributes in namespace " + Namespace.jsf.uri + "." + " Namespace " + Namespace.jsf.uri + " is intended for otherwise non-JSF-aware markup, such as <input type=\"text\" jsf:id >" + " It is not valid to have <h:commandButton jsf:id=\"button\" />.");
        }
        for (Mapper mapper : Mapper.values()) {
            if (!tag.getLocalName().equals(mapper.name())) continue;
            return mapper.elementConverter.decorate(tag);
        }
        return this.defaultElementConverter.decorate(tag);
    }

    private boolean hasJsfAttribute(Tag tag) {
        for (String string : tag.getAttributes().getNamespaces()) {
            if (!Namespace.jsf.uri.equals(string)) continue;
            return true;
        }
        return false;
    }

    private static class ElementConverter
    implements TagDecorator {
        private String localName;
        private Namespace namespace;
        private String arbiterAttributeName;
        private String arbiterAttributeNamespace = "";
        private Map<String, String> additionalMappings = new HashMap<String, String>();
        private String otherHtmlIdAttribute;

        private ElementConverter() {
        }

        private ElementConverter(String string) {
            this(string, (String)null);
        }

        private ElementConverter(String string, String string2) {
            String[] stringArray = string.split(":");
            this.namespace = Namespace.valueOf(stringArray[0]);
            this.localName = stringArray[1];
            this.arbiterAttributeName = string2;
            if (string2 != null && string2.indexOf(58) > 0) {
                stringArray = string2.split(":");
                this.arbiterAttributeNamespace = Namespace.valueOf(stringArray[0]).uri;
                this.arbiterAttributeName = stringArray[1];
            }
        }

        private ElementConverter map(String string, String string2) {
            this.additionalMappings.put(string, string2);
            return this;
        }

        private ElementConverter id(String string) {
            this.otherHtmlIdAttribute = string;
            return this;
        }

        public Tag decorate(Tag tag) {
            if (this.arbiterAttributeName == null) {
                return this.convertTag(tag, this.namespace, this.localName);
            }
            TagAttribute tagAttribute = tag.getAttributes().get(this.arbiterAttributeNamespace, this.arbiterAttributeName);
            if (tagAttribute == null) {
                return null;
            }
            String string = this.additionalMappings.get(tagAttribute.getValue());
            if (string == null) {
                string = this.localName;
            }
            return this.convertTag(tag, this.namespace, string);
        }

        protected Tag convertTag(Tag tag, Namespace namespace, String string) {
            Location location = tag.getLocation();
            String string2 = namespace.uri;
            String string3 = namespace.name() + ":" + string;
            TagAttributes tagAttributes = this.convertAttributes(tag.getAttributes());
            Tag tag2 = new Tag(location, string2, string, string3, tagAttributes);
            for (TagAttribute tagAttribute : tagAttributes.getAll()) {
                tagAttribute.setTag(tag2);
            }
            return tag2;
        }

        protected TagAttributes convertAttributes(TagAttributes tagAttributes) {
            HashMap<String, TagAttribute> hashMap = new HashMap<String, TagAttribute>();
            TagAttribute tagAttribute = this.createElementName(tagAttributes.getTag());
            hashMap.put(tagAttribute.getQName(), tagAttribute);
            for (TagAttribute tagAttribute2 : tagAttributes.getAll()) {
                TagAttribute tagAttribute3 = this.convertTagAttribute(tagAttribute2);
                hashMap.put(tagAttribute3.getQName(), tagAttribute3);
            }
            return new TagAttributesImpl(hashMap.values().toArray(new TagAttribute[hashMap.size()]));
        }

        private TagAttribute createElementName(Tag tag) {
            Location location = tag.getLocation();
            String string = Namespace.p.uri;
            String string2 = "elementName";
            String string3 = "p:" + string2;
            String string4 = tag.getLocalName();
            return new TagAttributeImpl(location, string, string2, string3, string4);
        }

        protected TagAttribute convertTagAttribute(TagAttribute tagAttribute) {
            String string;
            Location location = tagAttribute.getLocation();
            String string2 = tagAttribute.getNamespace();
            String string3 = tagAttribute.getLocalName();
            String string4 = tagAttribute.getValue();
            if (Namespace.jsf.uri.equals(tagAttribute.getNamespace())) {
                string = string3;
                string2 = "";
            } else {
                if (string2.length() != 0 && !string2.equals(tagAttribute.getTag().getNamespace())) {
                    return tagAttribute;
                }
                if (tagAttribute.getLocalName().equals(this.otherHtmlIdAttribute)) {
                    string = "id";
                    string3 = "id";
                } else {
                    string = "p:" + string3;
                    string2 = Namespace.p.uri;
                }
            }
            return new TagAttributeImpl(location, string2, string3, string, string4);
        }

        static /* synthetic */ ElementConverter access$200(ElementConverter elementConverter, String string) {
            return elementConverter.id(string);
        }

        static /* synthetic */ ElementConverter access$300(ElementConverter elementConverter, String string, String string2) {
            return elementConverter.map(string, string2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Namespace {
        p("http://xmlns.jcp.org/jsf/passthrough"),
        jsf("http://xmlns.jcp.org/jsf"),
        h("http://java.sun.com/jsf/html");

        private String uri;

        private Namespace(String string2) {
            this.uri = string2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mapper {
        a(new ElementConverter("h:commandLink", "jsf:action"), new ElementConverter("h:commandLink", "jsf:actionListener"), new ElementConverter("h:outputLink", "jsf:value"), new ElementConverter("h:link", "jsf:outcome")),
        img("h:graphicImage"),
        body("h:body"),
        head("h:head"),
        label("h:outputLabel"),
        script("h:outputScript"),
        link("h:outputStylesheet"),
        form("h:form"),
        textarea("h:inputTextarea"),
        button(new ElementConverter("h:button", "jsf:outcome"), new ElementConverter("h:commandButton")),
        select(ElementConverter.access$200(new ElementConverter("h:selectManyListbox", "multiple"), "name"), ElementConverter.access$200(new ElementConverter("h:selectOneListbox"), "name")),
        input(ElementConverter.access$300(ElementConverter.access$300(ElementConverter.access$300(ElementConverter.access$300(ElementConverter.access$300(ElementConverter.access$300(ElementConverter.access$300(ElementConverter.access$300(ElementConverter.access$300(ElementConverter.access$300(ElementConverter.access$300(ElementConverter.access$300(ElementConverter.access$300(ElementConverter.access$300(ElementConverter.access$300(ElementConverter.access$300(ElementConverter.access$300(ElementConverter.access$300(ElementConverter.access$300(ElementConverter.access$200(new ElementConverter("h:inputText", "type"), "name"), "hidden", "inputHidden"), "password", "inputSecret"), "number", "inputText"), "search", "inputText"), "email", "inputText"), "datetime", "inputText"), "date", "inputText"), "month", "inputText"), "week", "inputText"), "time", "inputText"), "datetime-local", "inputText"), "range", "inputText"), "color", "inputText"), "url", "inputText"), "checkbox", "selectBooleanCheckbox"), "file", "inputFile"), "submit", "commandButton"), "reset", "commandButton"), "button", "button"));

        private ElementConverter elementConverter;

        private Mapper(final ElementConverter ... elementConverterArray) {
            this.elementConverter = elementConverterArray.length == 1 ? elementConverterArray[0] : new ElementConverter(){

                public Tag decorate(Tag tag) {
                    for (ElementConverter elementConverter : elementConverterArray) {
                        Tag tag2 = elementConverter.decorate(tag);
                        if (tag2 == null) continue;
                        return tag2;
                    }
                    return null;
                }
            };
        }

        private Mapper(String string2) {
            this.elementConverter = new ElementConverter(string2);
        }
    }
}

