/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag;

import com.sun.faces.facelets.el.LegacyMethodBinding;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.el.MethodExpression;
import javax.faces.el.MethodBinding;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRule;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.MetadataTarget;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;

public final class MethodRule
extends MetaRule {
    private final String methodName;
    private final Class returnTypeClass;
    private final Class[] params;

    public MethodRule(String string, Class clazz, Class[] classArray) {
        this.methodName = string;
        this.returnTypeClass = clazz;
        this.params = classArray;
    }

    public Metadata applyRule(String string, TagAttribute tagAttribute, MetadataTarget metadataTarget) {
        Method method;
        if (!string.equals(this.methodName)) {
            return null;
        }
        if (MethodBinding.class.equals((Object)metadataTarget.getPropertyType(string))) {
            Method method2 = metadataTarget.getWriteMethod(string);
            if (method2 != null) {
                return new MethodBindingMetadata(method2, tagAttribute, this.returnTypeClass, this.params);
            }
        } else if (MethodExpression.class.equals((Object)metadataTarget.getPropertyType(string)) && (method = metadataTarget.getWriteMethod(string)) != null) {
            return new MethodExpressionMetadata(method, tagAttribute, this.returnTypeClass, this.params);
        }
        return null;
    }

    private static class MethodExpressionMetadata
    extends Metadata {
        private final Method _method;
        private final TagAttribute _attribute;
        private Class[] _paramList;
        private Class _returnType;

        public MethodExpressionMetadata(Method method, TagAttribute tagAttribute, Class clazz, Class[] classArray) {
            this._method = method;
            this._attribute = tagAttribute;
            this._paramList = classArray;
            this._returnType = clazz;
        }

        public void applyMetadata(FaceletContext faceletContext, Object object) {
            MethodExpression methodExpression = this._attribute.getMethodExpression(faceletContext, this._returnType, this._paramList);
            try {
                this._method.invoke(object, methodExpression);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new TagAttributeException(this._attribute, invocationTargetException.getCause());
            }
            catch (Exception exception) {
                throw new TagAttributeException(this._attribute, (Throwable)exception);
            }
        }
    }

    private static class MethodBindingMetadata
    extends Metadata {
        private final Method _method;
        private final TagAttribute _attribute;
        private Class[] _paramList;
        private Class _returnType;

        public MethodBindingMetadata(Method method, TagAttribute tagAttribute, Class clazz, Class[] classArray) {
            this._method = method;
            this._attribute = tagAttribute;
            this._paramList = classArray;
            this._returnType = clazz;
        }

        public void applyMetadata(FaceletContext faceletContext, Object object) {
            MethodExpression methodExpression = this._attribute.getMethodExpression(faceletContext, this._returnType, this._paramList);
            try {
                this._method.invoke(object, new LegacyMethodBinding(methodExpression));
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new TagAttributeException(this._attribute, invocationTargetException.getCause());
            }
            catch (Exception exception) {
                throw new TagAttributeException(this._attribute, (Throwable)exception);
            }
        }
    }
}

