/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.composite;

import com.sun.faces.facelets.tag.TagHandlerImpl;
import com.sun.faces.facelets.tag.composite.RelocateListener;
import com.sun.faces.util.FacesLogger;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.view.Location;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagException;

public class InsertChildrenHandler
extends TagHandlerImpl {
    private final Logger LOGGER = FacesLogger.TAGLIB.getLogger();
    private static final String REQUIRED_ATTRIBUTE = "required";
    private TagAttribute required = this.getAttribute("required");

    public InsertChildrenHandler(TagConfig tagConfig) {
        super(tagConfig);
    }

    public void apply(FaceletContext faceletContext, UIComponent uIComponent) throws IOException {
        UIComponent uIComponent2 = UIComponent.getCurrentCompositeComponent((FacesContext)faceletContext.getFacesContext());
        if (uIComponent2 != null) {
            int n = uIComponent.getChildCount();
            uIComponent2.subscribeToEvent(PostAddToViewEvent.class, (ComponentSystemEventListener)new RelocateChildrenListener(faceletContext, uIComponent, n, this.tag.getLocation()));
        }
    }

    private class RelocateChildrenListener
    extends RelocateListener {
        private FaceletContext ctx;
        private UIComponent component;
        private int idx;
        private Location location;

        RelocateChildrenListener(FaceletContext faceletContext, UIComponent uIComponent, int n, Location location) {
            this.ctx = faceletContext;
            this.component = uIComponent;
            if (!uIComponent.getAttributes().containsKey("idx")) {
                uIComponent.getAttributes().put("idx", n);
            }
            this.idx = n;
            this.location = location;
        }

        public void processEvent(ComponentSystemEvent componentSystemEvent) throws AbortProcessingException {
            UIComponent uIComponent = componentSystemEvent.getComponent();
            if (uIComponent == null) {
                return;
            }
            Resource resource = this.getBackingResource(uIComponent);
            while (uIComponent != null && !this.resourcesMatch(resource, this.location)) {
                if ((uIComponent = UIComponent.getCompositeComponentParent((UIComponent)uIComponent)) == null) continue;
                resource = this.getBackingResource(uIComponent);
            }
            if (uIComponent == null) {
                if (InsertChildrenHandler.this.LOGGER.isLoggable(Level.WARNING)) {
                    InsertChildrenHandler.this.LOGGER.log(Level.WARNING, "jsf.composite.component.insertchildren.missing.template", this.location.toString());
                }
                return;
            }
            if (uIComponent.getChildCount() == 0 && this.isRequired()) {
                this.throwRequiredException(this.ctx, uIComponent);
            }
            List list = uIComponent.getChildren();
            List list2 = this.component.getChildren();
            for (UIComponent uIComponent2 : list) {
                String string = (String)uIComponent2.getAttributes().get("com.sun.faces.facelets.MARK_ID");
                String string2 = this.component.getId();
                if (string == null || string2 == null) continue;
                uIComponent.getAttributes().put(string, string2);
            }
            if (list2.size() < this.getIdx()) {
                list2.addAll(list);
            } else {
                list2.addAll(this.getIdx(), list);
            }
        }

        private int getIdx() {
            Integer n = (Integer)this.component.getAttributes().get("idx");
            return n != null ? n : this.idx;
        }

        private void throwRequiredException(FaceletContext faceletContext, UIComponent uIComponent) {
            throw new TagException(InsertChildrenHandler.this.tag, "Unable to find any children components nested within parent composite component with id '" + uIComponent.getClientId(faceletContext.getFacesContext()) + '\'');
        }

        private boolean isRequired() {
            return InsertChildrenHandler.this.required != null && InsertChildrenHandler.this.required.getBoolean(this.ctx);
        }
    }
}

