/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.lifecycle.ApplyRequestValuesPhase;
import com.sun.faces.lifecycle.ClientWindowFactoryImpl;
import com.sun.faces.lifecycle.InvokeApplicationPhase;
import com.sun.faces.lifecycle.Phase;
import com.sun.faces.lifecycle.ProcessValidationsPhase;
import com.sun.faces.lifecycle.RenderResponsePhase;
import com.sun.faces.lifecycle.RestoreViewPhase;
import com.sun.faces.lifecycle.UpdateModelValuesPhase;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PhaseListener;
import javax.faces.event.PostConstructApplicationEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.faces.lifecycle.ClientWindow;
import javax.faces.lifecycle.ClientWindowFactory;
import javax.faces.lifecycle.Lifecycle;

public class LifecycleImpl
extends Lifecycle {
    private static Logger LOGGER = FacesLogger.LIFECYCLE.getLogger();
    private Phase response = new RenderResponsePhase();
    private Phase[] phases = new Phase[]{null, new RestoreViewPhase(), new ApplyRequestValuesPhase(), new ProcessValidationsPhase(), new UpdateModelValuesPhase(), new InvokeApplicationPhase(), this.response};
    private List<PhaseListener> listeners = new CopyOnWriteArrayList<PhaseListener>();
    private boolean isClientWindowEnabled = false;
    private WebConfiguration config;

    public LifecycleImpl() {
    }

    public LifecycleImpl(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        this.config = WebConfiguration.getInstance(externalContext);
        facesContext.getApplication().subscribeToEvent(PostConstructApplicationEvent.class, Application.class, (SystemEventListener)new PostConstructApplicationListener());
    }

    private void postConstructApplicationInitialization() {
        String string = this.config.getOptionValue(WebConfiguration.WebContextInitParameter.ClientWindowMode);
        this.isClientWindowEnabled = null != string && !string.equals(WebConfiguration.WebContextInitParameter.ClientWindowMode.getDefaultValue());
    }

    public void attachWindow(FacesContext facesContext) {
        if (!this.isClientWindowEnabled) {
            return;
        }
        if (facesContext == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context"));
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        ClientWindow clientWindow = externalContext.getClientWindow();
        if (null == clientWindow && null != (clientWindow = this.createClientWindow(facesContext))) {
            clientWindow.decode(facesContext);
            externalContext.setClientWindow(clientWindow);
        }
    }

    private ClientWindow createClientWindow(FacesContext facesContext) {
        ClientWindowFactory clientWindowFactory = null;
        clientWindowFactory = Util.isUnitTestModeEnabled() ? new ClientWindowFactoryImpl(false) : (ClientWindowFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.ClientWindowFactory");
        return clientWindowFactory.getClientWindow(facesContext);
    }

    public void execute(FacesContext facesContext) throws FacesException {
        if (facesContext == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context"));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("execute(" + facesContext + ")");
        }
        int n = this.phases.length - 1;
        for (int i = 1; i < n && !facesContext.getRenderResponse() && !facesContext.getResponseComplete(); ++i) {
            this.phases[i].doPhase(facesContext, this, this.listeners.listIterator());
        }
    }

    public void render(FacesContext facesContext) throws FacesException {
        if (facesContext == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context"));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("render(" + facesContext + ")");
        }
        if (!facesContext.getResponseComplete()) {
            this.response.doPhase(facesContext, this, this.listeners.listIterator());
        }
    }

    public void addPhaseListener(PhaseListener phaseListener) {
        if (phaseListener == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "listener"));
        }
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArrayList<PhaseListener>();
        }
        if (this.listeners.contains(phaseListener)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "jsf.lifecycle.duplicate_phase_listener_detected", phaseListener.getClass().getName());
            }
        } else {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "addPhaseListener({0},{1})", new Object[]{phaseListener.getPhaseId().toString(), phaseListener.getClass().getName()});
            }
            this.listeners.add(phaseListener);
        }
    }

    public PhaseListener[] getPhaseListeners() {
        return this.listeners.toArray(new PhaseListener[this.listeners.size()]);
    }

    public void removePhaseListener(PhaseListener phaseListener) {
        if (phaseListener == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "listener"));
        }
        if (this.listeners.remove(phaseListener) && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "removePhaseListener({0})", new Object[]{phaseListener.getClass().getName()});
        }
    }

    private class PostConstructApplicationListener
    implements SystemEventListener {
        private PostConstructApplicationListener() {
        }

        public boolean isListenerForSource(Object object) {
            return object instanceof Application;
        }

        public void processEvent(SystemEvent systemEvent) throws AbortProcessingException {
            LifecycleImpl.this.postConstructApplicationInitialization();
        }
    }
}

