/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.io.Base64InputStream;
import com.sun.faces.io.Base64OutputStreamWriter;
import com.sun.faces.renderkit.ByteArrayGuard;
import com.sun.faces.renderkit.StateHelper;
import com.sun.faces.util.DebugObjectOutputStream;
import com.sun.faces.util.DebugUtil;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.faces.FacesException;
import javax.faces.component.NamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class ClientSideStateHelper
extends StateHelper {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private ByteArrayGuard guard;
    private boolean stateTimeoutEnabled;
    private long stateTimeout;
    private int csBuffSize;
    private boolean debugSerializedState;
    protected boolean namespaceParameters;

    public ClientSideStateHelper() {
        this.init();
    }

    public void writeState(FacesContext facesContext, Object object, StringBuilder stringBuilder) throws IOException {
        if (stringBuilder != null) {
            this.doWriteState(facesContext, object, new StringBuilderWriter(stringBuilder));
        } else {
            String string;
            Object object2;
            ResponseWriter responseWriter = facesContext.getResponseWriter();
            responseWriter.startElement("input", null);
            responseWriter.writeAttribute("type", (Object)"hidden", null);
            String string2 = "javax.faces.ViewState";
            if (this.namespaceParameters && (object2 = facesContext.getViewRoot()) instanceof NamingContainer && (string = object2.getContainerClientId(facesContext)) != null) {
                string2 = string + string2;
            }
            responseWriter.writeAttribute("name", (Object)string2, null);
            if (this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableViewStateIdRendering)) {
                object2 = Util.getViewStateId(facesContext);
                responseWriter.writeAttribute("id", object2, null);
            }
            object2 = new StringBuilder();
            this.doWriteState(facesContext, object, new StringBuilderWriter((StringBuilder)object2));
            responseWriter.writeAttribute("value", (Object)((StringBuilder)object2).toString(), null);
            if (this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.AutoCompleteOffOnViewState)) {
                responseWriter.writeAttribute("autocomplete", (Object)"off", null);
            }
            responseWriter.endElement("input");
            this.writeClientWindowField(facesContext, responseWriter);
            this.writeRenderKitIdField(facesContext, responseWriter);
        }
    }

    public Object getState(FacesContext facesContext, String string) throws IOException {
        String string2 = ClientSideStateHelper.getStateParamValue(facesContext);
        if (string2 == null) {
            return null;
        }
        if ("stateless".equals(string2)) {
            return "stateless";
        }
        return this.doGetState(string2);
    }

    protected Object doGetState(String string) {
        if ("stateless".equals(string)) {
            return null;
        }
        ObjectInputStream objectInputStream = null;
        InputStream inputStream = new Base64InputStream(string);
        try {
            Object object;
            if (this.guard != null) {
                byte[] byArray = string.getBytes("UTF-8");
                int n = inputStream.read(byArray, 0, byArray.length);
                object = new byte[n];
                inputStream.reset();
                inputStream.read((byte[])object, 0, ((byte[])object).length);
                byArray = this.guard.decrypt((byte[])object);
                if (byArray == null) {
                    Object var7_15 = null;
                    return var7_15;
                }
                inputStream = new ByteArrayInputStream(byArray);
            }
            if (this.compressViewState) {
                inputStream = new GZIPInputStream(inputStream);
            }
            objectInputStream = this.serialProvider.createObjectInputStream(inputStream);
            long l = 0L;
            if (this.stateTimeoutEnabled) {
                try {
                    l = objectInputStream.readLong();
                }
                catch (IOException iOException) {
                    Object var7_16;
                    block38: {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Client state timeout is enabled, but unable to find the time marker in the serialized state.  Assuming state to be old and returning null.");
                        }
                        var7_16 = null;
                        if (objectInputStream != null) {
                            try {
                                objectInputStream.close();
                            }
                            catch (IOException iOException2) {
                                if (!LOGGER.isLoggable(Level.FINEST)) break block38;
                                LOGGER.log(Level.FINEST, "Closing stream", iOException2);
                            }
                        }
                    }
                    return var7_16;
                }
            }
            object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            if (l != 0L && this.hasStateExpired(l)) {
                Object var8_20 = null;
                return var8_20;
            }
            Object[] objectArray = new Object[]{object, object2};
            return objectArray;
        }
        catch (OptionalDataException optionalDataException) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, optionalDataException.getMessage(), optionalDataException);
            }
            throw new FacesException((Throwable)optionalDataException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, classNotFoundException.getMessage(), classNotFoundException);
            }
            throw new FacesException((Throwable)classNotFoundException);
        }
        catch (InvalidClassException invalidClassException) {
            Object var5_11 = null;
            return var5_11;
        }
        catch (IOException iOException) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, iOException.getMessage(), iOException);
            }
            throw new FacesException((Throwable)iOException);
        }
        finally {
            block39: {
                if (objectInputStream != null) {
                    try {
                        objectInputStream.close();
                    }
                    catch (IOException iOException) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block39;
                        LOGGER.log(Level.FINEST, "Closing stream", iOException);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWriteState(FacesContext facesContext, Object object, Writer writer) throws IOException {
        if (facesContext.getViewRoot().isTransient()) {
            writer.write("stateless");
            writer.flush();
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStream outputStream = null;
        outputStream = this.compressViewState ? new GZIPOutputStream((OutputStream)byteArrayOutputStream, this.csBuffSize) : byteArrayOutputStream;
        ObjectOutputStream objectOutputStream = null;
        try {
            OutputStream outputStream2;
            Object object2;
            objectOutputStream = this.serialProvider.createObjectOutputStream(new BufferedOutputStream(outputStream));
            if (this.stateTimeoutEnabled) {
                objectOutputStream.writeLong(System.currentTimeMillis());
            }
            Object[] objectArray = (Object[])object;
            if (this.debugSerializedState) {
                object2 = new ByteArrayOutputStream();
                outputStream2 = new DebugObjectOutputStream((OutputStream)object2);
                try {
                    ((ObjectOutputStream)outputStream2).writeObject(objectArray[0]);
                }
                catch (Exception exception) {
                    throw new FacesException("Serialization error. Path to offending instance: " + ((DebugObjectOutputStream)outputStream2).getStack(), (Throwable)exception);
                }
            }
            objectOutputStream.writeObject(objectArray[0]);
            if (this.debugSerializedState) {
                object2 = new ByteArrayOutputStream();
                outputStream2 = new DebugObjectOutputStream((OutputStream)object2);
                try {
                    ((ObjectOutputStream)outputStream2).writeObject(objectArray[1]);
                }
                catch (Exception exception) {
                    DebugUtil.printState((Map)objectArray[1], LOGGER);
                    throw new FacesException("Serialization error. Path to offending instance: " + ((DebugObjectOutputStream)outputStream2).getStack(), (Throwable)exception);
                }
            }
            objectOutputStream.writeObject(objectArray[1]);
            objectOutputStream.flush();
            objectOutputStream.close();
            objectOutputStream = null;
            object2 = byteArrayOutputStream.toByteArray();
            if (this.guard != null) {
                object2 = this.guard.encrypt((byte[])object2);
            }
            outputStream2 = new Base64OutputStreamWriter(((Object)object2).length, writer);
            ((Base64OutputStreamWriter)outputStream2).write((byte[])object2, 0, ((Object)object2).length);
            ((Base64OutputStreamWriter)outputStream2).finish();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Client State: total number of characters written: {0}", ((Base64OutputStreamWriter)outputStream2).getTotalCharsWritten());
            }
        }
        finally {
            block19: {
                if (objectOutputStream != null) {
                    try {
                        objectOutputStream.close();
                    }
                    catch (IOException iOException) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block19;
                        LOGGER.log(Level.FINEST, "Closing stream", iOException);
                    }
                }
            }
        }
    }

    protected boolean hasStateExpired(long l) {
        if (this.stateTimeoutEnabled) {
            long l2 = (System.currentTimeMillis() - l) / 60000L;
            return l2 > this.stateTimeout;
        }
        return false;
    }

    protected void init() {
        String string;
        if (this.webConfig.canProcessJndiEntries() && !this.webConfig.isSet(WebConfiguration.BooleanWebContextInitParameter.DisableClientStateEncryption)) {
            this.guard = new ByteArrayGuard();
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "jsf.config.webconfig.enventry.clientencrypt");
        }
        this.stateTimeoutEnabled = this.webConfig.isSet(WebConfiguration.WebContextInitParameter.ClientStateTimeout);
        if (this.stateTimeoutEnabled) {
            string = this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.ClientStateTimeout);
            try {
                this.stateTimeout = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.stateTimeout = Long.parseLong(WebConfiguration.WebContextInitParameter.ClientStateTimeout.getDefaultValue());
            }
        }
        string = this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.ClientStateWriteBufferSize);
        String string2 = WebConfiguration.WebContextInitParameter.ClientStateWriteBufferSize.getDefaultValue();
        try {
            this.csBuffSize = Integer.parseInt(string);
            if (this.csBuffSize % 2 != 0) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "jsf.renderkit.resstatemgr.clientbuf_div_two", new Object[]{WebConfiguration.WebContextInitParameter.ClientStateWriteBufferSize.getQualifiedName(), string, string2});
                }
                this.csBuffSize = Integer.parseInt(string2);
            } else {
                this.csBuffSize /= 2;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Using client state buffer size of " + this.csBuffSize);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.renderkit.resstatemgr.clientbuf_not_integer", new Object[]{WebConfiguration.WebContextInitParameter.ClientStateWriteBufferSize.getQualifiedName(), string, string2});
            }
            this.csBuffSize = Integer.parseInt(string2);
        }
        this.debugSerializedState = this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableClientStateDebugging);
        this.namespaceParameters = this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.NamespaceParameters);
    }

    public boolean isStateless(FacesContext facesContext, String string) throws IllegalStateException {
        if (facesContext.isPostback()) {
            Object object;
            try {
                object = this.getState(facesContext, string);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Cannot determine whether or not the request is stateless", iOException);
            }
            return object instanceof String && "stateless".equals((String)object);
        }
        throw new IllegalStateException("Cannot determine whether or not the request is stateless");
    }

    protected static final class StringBuilderWriter
    extends Writer {
        private StringBuilder sb;

        protected StringBuilderWriter(StringBuilder stringBuilder) {
            this.sb = stringBuilder;
        }

        public void write(int n) throws IOException {
            this.sb.append((char)n);
        }

        public void write(char[] cArray) throws IOException {
            this.sb.append(cArray);
        }

        public void write(String string) throws IOException {
            this.sb.append(string);
        }

        public void write(String string, int n, int n2) throws IOException {
            this.sb.append(string.toCharArray(), n, n2);
        }

        public Writer append(CharSequence charSequence) throws IOException {
            this.sb.append(charSequence);
            return this;
        }

        public Writer append(CharSequence charSequence, int n, int n2) throws IOException {
            this.sb.append(charSequence, n, n2);
            return this;
        }

        public Writer append(char c) throws IOException {
            this.sb.append(c);
            return this;
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            this.sb.append(cArray, n, n2);
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }
    }
}

