/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SelectItemsIterator<T extends SelectItem>
implements Iterator<SelectItem> {
    private ComponentAwareSelectItemIterator<SelectItem> items;
    private ListIterator<UIComponent> kids;
    private SingleElementIterator singleItemIterator;
    private FacesContext ctx;

    public SelectItemsIterator(FacesContext facesContext, UIComponent uIComponent) {
        this.kids = uIComponent.getChildren().listIterator();
        this.ctx = facesContext;
    }

    @Override
    public boolean hasNext() {
        if (this.items != null) {
            if (this.items.hasNext()) {
                return true;
            }
            this.items = null;
        }
        Object object = this.findNextValidChild();
        while (object != null) {
            this.initializeItems(object);
            if (this.items != null) {
                return true;
            }
            object = this.findNextValidChild();
        }
        return false;
    }

    @Override
    public SelectItem next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.items != null) {
            return (SelectItem)this.items.next();
        }
        return this.next();
    }

    public UIComponent currentSelectComponent() {
        UIComponent uIComponent = this.items.currentSelectComponent();
        return uIComponent;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void initializeItems(Object object) {
        if (object instanceof UISelectItem) {
            UISelectItem uISelectItem = (UISelectItem)object;
            SelectItem selectItem = (SelectItem)uISelectItem.getValue();
            if (selectItem == null) {
                selectItem = new SelectItem(uISelectItem.getItemValue(), uISelectItem.getItemLabel(), uISelectItem.getItemDescription(), uISelectItem.isItemDisabled(), uISelectItem.isItemEscaped(), uISelectItem.isNoSelectionOption());
            }
            this.updateSingeItemIterator((UIComponent)uISelectItem, selectItem);
            this.items = this.singleItemIterator;
        } else if (object instanceof UISelectItems) {
            UISelectItems uISelectItems = (UISelectItems)object;
            Object object2 = uISelectItems.getValue();
            if (object2 != null) {
                if (object2 instanceof SelectItem) {
                    this.updateSingeItemIterator((UIComponent)uISelectItems, (SelectItem)object2);
                    this.items = this.singleItemIterator;
                } else if (object2.getClass().isArray()) {
                    this.items = new ArrayIterator(this.ctx, (UISelectItems)object, object2);
                } else if (object2 instanceof Iterable) {
                    this.items = new IterableItemIterator(this.ctx, (UISelectItems)object, (Iterable)object2);
                } else if (object2 instanceof Map) {
                    this.items = new MapIterator((Map)object2, uISelectItems.getParent());
                } else {
                    throw new IllegalArgumentException();
                }
            }
            if (this.items != null && !this.items.hasNext()) {
                this.items = null;
            }
        }
    }

    private Object findNextValidChild() {
        if (this.kids.hasNext()) {
            UIComponent uIComponent = this.kids.next();
            while (this.kids.hasNext() && !(uIComponent instanceof UISelectItem) && !(uIComponent instanceof UISelectItems)) {
                uIComponent = this.kids.next();
            }
            if (uIComponent instanceof UISelectItem || uIComponent instanceof UISelectItems) {
                return uIComponent;
            }
        }
        return null;
    }

    private void updateSingeItemIterator(UIComponent uIComponent, SelectItem selectItem) {
        if (this.singleItemIterator == null) {
            this.singleItemIterator = new SingleElementIterator();
        }
        this.singleItemIterator.updateItem(uIComponent, selectItem);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IterableItemIterator
    extends GenericObjectSelectItemIterator {
        private FacesContext ctx;
        private Iterator<?> iterator;

        private IterableItemIterator(FacesContext facesContext, UISelectItems uISelectItems, Iterable<?> iterable) {
            super(uISelectItems);
            this.ctx = facesContext;
            this.iterator = iterable.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public SelectItem next() {
            Object obj = this.iterator.next();
            if (obj instanceof SelectItem) {
                return (SelectItem)obj;
            }
            return this.getSelectItemFor(this.ctx, obj);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class ArrayIterator
    extends GenericObjectSelectItemIterator {
        private FacesContext ctx;
        private Object array;
        private int count;
        private int index;

        private ArrayIterator(FacesContext facesContext, UISelectItems uISelectItems, Object object) {
            super(uISelectItems);
            this.ctx = facesContext;
            this.array = object;
            this.count = Array.getLength(object);
        }

        public boolean hasNext() {
            return this.index < this.count;
        }

        public SelectItem next() {
            Object object;
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            if ((object = Array.get(this.array, this.index++)) instanceof SelectItem) {
                return (SelectItem)object;
            }
            return this.getSelectItemFor(this.ctx, object);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ComponentAwareSelectItemIterator<E>
    extends Iterator<E> {
        public UIComponent currentSelectComponent();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class GenericObjectSelectItemIterator
    implements ComponentAwareSelectItemIterator<SelectItem> {
        private GenericObjectSelectItem genericObjectSI;
        protected transient UISelectItems sourceComponent;

        protected GenericObjectSelectItemIterator(UISelectItems uISelectItems) {
            this.sourceComponent = uISelectItems;
        }

        @Override
        public UIComponent currentSelectComponent() {
            return this.sourceComponent;
        }

        protected SelectItem getSelectItemFor(FacesContext facesContext, Object object) {
            if (this.genericObjectSI == null) {
                this.genericObjectSI = new GenericObjectSelectItem(this.sourceComponent);
            }
            this.genericObjectSI.updateItem(facesContext, object);
            return this.genericObjectSI;
        }

        private static final class GenericObjectSelectItem
        extends SelectItem {
            private static final String VAR = "var";
            private static final String ITEM_VALUE = "itemValue";
            private static final String ITEM_LABEL = "itemLabel";
            private static final String ITEM_DESCRIPTION = "itemDescription";
            private static final String ITEM_ESCAPED = "itemLabelEscaped";
            private static final String ITEM_DISABLED = "itemDisabled";
            private static final String NO_SELECTION_OPTION = "noSelectionOption";
            private static final String NO_SELECTION_VALUE = "noSelectionValue";
            private String var;
            private UISelectItems sourceComponent;

            private GenericObjectSelectItem(UISelectItems uISelectItems) {
                this.var = (String)uISelectItems.getAttributes().get(VAR);
                this.sourceComponent = uISelectItems;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void updateItem(FacesContext facesContext, Object object) {
                Map map = facesContext.getExternalContext().getRequestMap();
                Object object2 = null;
                if (this.var != null) {
                    object2 = map.put(this.var, object);
                }
                try {
                    Map map2 = this.sourceComponent.getAttributes();
                    Object v = map2.get(ITEM_VALUE);
                    Object v2 = map2.get(ITEM_LABEL);
                    Object v3 = map2.get(ITEM_DESCRIPTION);
                    Object v4 = map2.get(ITEM_ESCAPED);
                    Object v5 = map2.get(ITEM_DISABLED);
                    Object v6 = map2.get(NO_SELECTION_VALUE);
                    Object v7 = map2.get(NO_SELECTION_OPTION);
                    this.setValue(v != null ? v : object);
                    this.setLabel(v2 != null ? v2.toString() : object.toString());
                    this.setDescription(v3 != null ? v3.toString() : null);
                    this.setEscape(v4 != null ? Boolean.valueOf(v4.toString()) : true);
                    this.setDisabled(v5 != null ? Boolean.valueOf(v5.toString()) : false);
                    if (null != v7) {
                        this.setNoSelectionOption(Boolean.valueOf(v7.toString()));
                    } else if (null != v6) {
                        this.setNoSelectionOption(this.getValue().equals(v6));
                    }
                }
                finally {
                    if (this.var != null) {
                        if (object2 != null) {
                            map.put(this.var, object2);
                        } else {
                            map.remove(this.var);
                        }
                    }
                }
            }

            private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
                throw new NotSerializableException();
            }

            private void readObject(ObjectInputStream objectInputStream) throws IOException {
                throw new NotSerializableException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MapIterator
    implements ComponentAwareSelectItemIterator<SelectItem> {
        private SelectItem item = new SelectItem();
        private Iterator iterator;
        private transient UIComponent parent;

        private MapIterator(Map map, UIComponent uIComponent) {
            this.iterator = map.entrySet().iterator();
            this.parent = uIComponent;
        }

        @Override
        public UIComponent currentSelectComponent() {
            return this.parent;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public SelectItem next() {
            Map.Entry entry = (Map.Entry)this.iterator.next();
            Object k = entry.getKey();
            Object v = entry.getValue();
            this.item.setLabel(k != null ? k.toString() : v.toString());
            this.item.setValue(v != null ? v : "");
            return this.item;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SingleElementIterator
    implements ComponentAwareSelectItemIterator<SelectItem> {
        private SelectItem item;
        private transient UIComponent selectComponent;
        private boolean nextCalled;

        private SingleElementIterator() {
        }

        @Override
        public UIComponent currentSelectComponent() {
            return this.selectComponent;
        }

        @Override
        public boolean hasNext() {
            return !this.nextCalled;
        }

        @Override
        public SelectItem next() {
            if (this.nextCalled) {
                throw new NoSuchElementException();
            }
            this.nextCalled = true;
            return this.item;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void updateItem(UIComponent uIComponent, SelectItem selectItem) {
            this.item = selectItem;
            this.selectComponent = uIComponent;
            this.nextCalled = false;
        }
    }
}

