/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugObjectOutputStream
extends ObjectOutputStream {
    private static final Field DEPTH_FIELD;
    final List<Object> stack = new ArrayList<Object>();
    boolean broken = false;

    public DebugObjectOutputStream(OutputStream outputStream) throws IOException {
        super(outputStream);
        this.enableReplaceObject(true);
    }

    @Override
    protected Object replaceObject(Object object) {
        int n = this.currentDepth();
        if (object instanceof IOException && n == 0) {
            this.broken = true;
        }
        if (!this.broken) {
            this.truncate(n);
            this.stack.add(object);
        }
        return object;
    }

    private void truncate(int n) {
        while (this.stack.size() > n) {
            this.pop();
        }
    }

    private Object pop() {
        return this.stack.remove(this.stack.size() - 1);
    }

    private int currentDepth() {
        try {
            Integer n = (Integer)DEPTH_FIELD.get(this);
            return n - 1;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
    }

    public List<Object> getStack() {
        return this.stack;
    }

    static {
        try {
            DEPTH_FIELD = ObjectOutputStream.class.getDeclaredField("depth");
            DEPTH_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new AssertionError((Object)noSuchFieldException);
        }
    }
}

