package com.javacodegeeks.androidgooglemapsexample;

import android.animation.ObjectAnimator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.os.Build;
import android.os.Handler;
import android.os.SystemClock;
import android.util.Property;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;

import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.Marker;

public class MarkerAnimation {

	static void animateMarkerToGB(final Marker marker, final LatLng finalPosition, final LatLngInterpolator latLngInterpolator) {
		final LatLng startPosition = marker.getPosition();
		final Handler handler = new Handler();
		final long start = SystemClock.uptimeMillis();
		final Interpolator interpolator = new AccelerateDecelerateInterpolator();
		final float durationInMs = 500;

		handler.post(new Runnable() {
			long elapsed;
			float t;
			float v;

			@Override
			public void run() {
				// Calculate progress using interpolator
				elapsed = SystemClock.uptimeMillis() - start;
				t = elapsed / durationInMs;
				v = interpolator.getInterpolation(t);

				marker.setPosition(latLngInterpolator.interpolate(v, startPosition, finalPosition));

				if (t < 1) {

					handler.postDelayed(this, 16);
				}
			}
		});
	}

	@TargetApi(Build.VERSION_CODES.HONEYCOMB)
	static void animateMarkerToHC(final Marker marker, final LatLng finalPosition, final LatLngInterpolator latLngInterpolator) {
		final LatLng startPosition = marker.getPosition();

		ValueAnimator valueAnimator = new ValueAnimator();
		valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener() {
			@Override
			public void onAnimationUpdate(ValueAnimator animation) {
				float v = animation.getAnimatedFraction();
				LatLng newPosition = latLngInterpolator.interpolate(v, startPosition, finalPosition);
				marker.setPosition(newPosition);
			}
		});
		valueAnimator.setFloatValues(0, 1);
		valueAnimator.setDuration(500);
		valueAnimator.start();
	}

	@TargetApi(Build.VERSION_CODES.ICE_CREAM_SANDWICH)
	static void animateMarkerToICS(Marker marker, LatLng finalPosition, final LatLngInterpolator latLngInterpolator) {
		TypeEvaluator<LatLng> typeEvaluator = new TypeEvaluator<LatLng>() {
			@Override
			public LatLng evaluate(float fraction, LatLng startValue, LatLng endValue) {
				return latLngInterpolator.interpolate(fraction, startValue, endValue);
			}
		};
		Property<Marker, LatLng> property = Property.of(Marker.class, LatLng.class, "position");
		ObjectAnimator animator = ObjectAnimator.ofObject(marker, property, typeEvaluator, finalPosition);
		animator.setDuration(500);
		animator.start();
	}
}