import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;

import org.w3c.dom.Document;


public class XpathSubStringDemo
{
		public static void main(String[] args) throws Exception
		{

				DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
				documentBuilderFactory.setNamespaceAware(true);
				DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
				Document doc = documentBuilder.parse("src/cricketTeam_info.xml");

				XPathFactory xpathFactory = XPathFactory.newInstance();
				XPath xpath = xpathFactory.newXPath();

				//XPath subtring example
				XPathExpression expr = xpath.compile("substring(//cricketer[name='MS Dhoni']/position,'1','4')");
				String substr = (String) expr.evaluate(doc, XPathConstants.STRING);
				System.out.println("The substring before Keeper is : " + substr);

				// XPath subtring-before example
				expr = xpath.compile("substring-before(//cricketer[name='MS Dhoni']/position,'-Keeper')");
				String substrbefore = (String) expr.evaluate(doc, XPathConstants.STRING);
				System.out.println("The substring before Keeper is : " + substrbefore);


				// XPath subtring-after example
				expr = xpath.compile("substring-after(//cricketer[name='MS Dhoni']/position,'Wicket-')");
				String substrafter = (String) expr.evaluate(doc, XPathConstants.STRING);
				System.out.println("The substring after Keeper is : " + substrafter);


		}
}
