import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;

import org.w3c.dom.Document;


public class XpathCountFunctionDemo
{
		public static void main(String[] args) throws Exception
		{

				DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
				documentBuilderFactory.setNamespaceAware(true);
				DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
				Document doc = documentBuilder.parse("src/cricketTeam_info.xml");

				XPathFactory xpathFactory = XPathFactory.newInstance();
				XPath xpath = xpathFactory.newXPath();

				//XPath count() example 1
				XPathExpression expr = xpath.compile("count(//cricketers/cricketer)");
				Number result = (Number) expr.evaluate(doc, XPathConstants.NUMBER);
				System.out.println("Total number of Cricketers in the squad is "+result);

				//XPath count() example 2
				XPathExpression expr = xpath.compile("count(//cricketers/cricketer[role='Bowler'])");
				Number result = (Number) expr.evaluate(doc, XPathConstants.NUMBER);
				System.out.println("The 'Bowlers' count in the squad is "+result);




		}
}
