package com.jcg;

import java.awt.Dimension;

import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;

/**
 * @author ashraf_sarhan
 * 
 */
@SuppressWarnings("serial")
public class TableCellRendererDemo extends JPanel {

	private static JTable table;

	public TableCellRendererDemo() {

		DefaultTableModel model = new DefaultTableModel(Constants.DATA,
				Constants.TABLE_HEADER);

		table = new JTable(model);

		// Set custom price color renderer
		PriceChangeColorRenderer colorRenderer = new PriceChangeColorRenderer();
		table.setDefaultRenderer(Object.class, colorRenderer);

		JScrollPane scrollpane = new JScrollPane(table);
		scrollpane.setPreferredSize(new Dimension(700, 182));
		scrollpane.setViewportView(table);

		JPanel panel = new JPanel();
		panel.setBorder(BorderFactory.createTitledBorder(
				BorderFactory.createEtchedBorder(), "Market Movers",
				TitledBorder.CENTER, TitledBorder.TOP));
		panel.add(scrollpane);
		add(panel);
	}

	public static void main(String[] args) {
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				try {
					createAndShowGUI();
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});

		new Thread(new Runnable() {
			public void run() {
				while (true) {
					try {
						SwingUtilities.invokeLater(new Runnable() {
							public void run() {
								TableDataFeeder.feedData(table);
							}
						});
						Thread.sleep(Constants.DATA_REFRESH_RATE);
					} catch (InterruptedException e) {
						e.printStackTrace();
					}
				}
			}
		}).start();
	}

	public static void createAndShowGUI() throws Exception {
		JFrame frame = new JFrame("Stocks Market Data");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.add(new TableCellRendererDemo());
		frame.pack();
		frame.setLocationRelativeTo(null);
		frame.setVisible(true);
	}
}
