package com.jcg;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.concurrent.ThreadLocalRandom;

import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

/**
 * @author ashraf_sarhan
 * 
 */
public class TableDataFeeder {

	private static boolean isPriceUp = true;

	public static void feedData(JTable table) {

		// Get a random index to apply the price update
		int randomRowIdx = ThreadLocalRandom.current().nextInt(0, 10);

		updatePrice(table, randomRowIdx);
	}

	private static void updatePrice(JTable table, int row) {

		DefaultTableModel model = (DefaultTableModel) table.getModel();

		Double oldPrice = (Double) model.getValueAt(row, Constants.PRICE_IDX);
		Double newPrice = 0.0;
		Double priceChange = 0.0;
		Double priceChangePercentage = 0.0;
		String priceChangePercentageStr = "";

		Double priceDelta = ThreadLocalRandom.current().nextDouble(
				Constants.PRICE_CHANGE_RANGE[0],
				Constants.PRICE_CHANGE_RANGE[1]);
		if (isPriceUp) {
			// Get a newer bigger price value
			newPrice = oldPrice + priceDelta;
			isPriceUp = false;
		} else {
			// Get a newer smaller price value
			newPrice = oldPrice - priceDelta;
			isPriceUp = true;
		}

		if (newPrice > 0.0) {
			priceChange = newPrice - oldPrice;
			priceChangePercentage = roundDouble(new Double(
					(newPrice / oldPrice - 1) * 100), Constants.ROUND_PLACES);
			if (priceChangePercentage > 0) {
				priceChangePercentageStr = Constants.PLUS_SIGN
						+ priceChangePercentage.toString()
						+ Constants.PERCENTAGE_SIGN;
			} else {
				priceChangePercentageStr = priceChangePercentage.toString()
						+ Constants.PERCENTAGE_SIGN;
			}

			// Update table row with the new values
			model.setValueAt(roundDouble(newPrice, Constants.ROUND_PLACES),
					row, Constants.PRICE_IDX);
			model.setValueAt(roundDouble(priceChange, Constants.ROUND_PLACES),
					row, Constants.CHANGE_IDX);
			model.setValueAt(priceChangePercentageStr, row,
					Constants.PERCENTAGE_CHANGE_IDX);
		}

	}

	private static Double roundDouble(double value, int places) {
		if (places < 0)
			throw new IllegalArgumentException();

		BigDecimal bd = new BigDecimal(value);
		bd = bd.setScale(places, RoundingMode.HALF_UP);
		return bd.doubleValue();
	}
}
