package com.javacodegeeks.camel;

import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.util.jndi.JndiContext;

public class CamelXPathFilterExample {
	public static void main(String[] args) throws Exception {
		JndiContext jndiContext = new JndiContext();
		jndiContext.bind("orderBean", new OrderProcessor());		
		CamelContext camelContext = new DefaultCamelContext(jndiContext);
		try {
			camelContext.addRoutes(new RouteBuilder() {
				@Override
				public void configure() throws Exception {
					 from("direct:start")
	                    .choice()
	                        .when().xpath("//available = 'true'").to("bean:orderBean")
	                    .end()
	                    .to("stream:out");
				}
			});
			camelContext.start();
			ProducerTemplate template = camelContext.createProducerTemplate();
			template.sendBody("direct:start", "<order><product>laptop</product><available>true</available></order>");
			template.sendBody("direct:start", "<order><product>books</product><available>false</available></order>");
		} finally {
			camelContext.stop();
		}
	}
}
