package com.javacodegeeks.example.util;
import java.util.Map;

import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.configuration.JobLocator;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class MyTaskScheduler extends QuartzJobBean{
	private String jobName;
	private JobLauncher jobLauncher;
	private JobLocator jobLocator;
	
	public JobLauncher getJobLauncher() {
		return jobLauncher;
	}
	public void setJobLauncher(JobLauncher jobLauncher) {
		this.jobLauncher = jobLauncher;
	}
	public JobLocator getJobLocator() {
		return jobLocator;
	}
	public void setJobLocator(JobLocator jobLocator) {
		this.jobLocator = jobLocator;
	}

	@Override
	protected void executeInternal(JobExecutionContext context)
			throws JobExecutionException {
		@SuppressWarnings("unchecked")
		Map<String,Object> mapData = context.getMergedJobDataMap();
		
		jobName = (String) mapData.get("jobName");
		
		try{			
			
			JobExecution execution = jobLauncher.run(jobLocator.getJob(jobName), new JobParameters());
			System.out.println("Execution Status: "+ execution.getStatus());
		}catch(Exception e){
			System.out.println("Encountered job execution exception! ");
			e.printStackTrace();
		}
		
	}

}
