/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.netty.channel.socket.nio;

import com.datastax.shaded.netty.channel.socket.nio.AbstractNioBossPool;
import com.datastax.shaded.netty.channel.socket.nio.NioClientBoss;
import com.datastax.shaded.netty.util.HashedWheelTimer;
import com.datastax.shaded.netty.util.ThreadNameDeterminer;
import com.datastax.shaded.netty.util.Timer;
import java.util.concurrent.Executor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NioClientBossPool
extends AbstractNioBossPool<NioClientBoss> {
    private final ThreadNameDeterminer determiner;
    private final Timer timer;
    private boolean stopTimer;

    public NioClientBossPool(Executor bossExecutor, int bossCount, Timer timer, ThreadNameDeterminer determiner) {
        super(bossExecutor, bossCount, false);
        this.determiner = determiner;
        this.timer = timer;
        this.init();
    }

    public NioClientBossPool(Executor bossExecutor, int bossCount) {
        this(bossExecutor, bossCount, new HashedWheelTimer(), null);
        this.stopTimer = true;
    }

    @Override
    protected NioClientBoss newBoss(Executor executor) {
        return new NioClientBoss(executor, this.timer, this.determiner);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.stopTimer) {
            this.timer.stop();
        }
    }

    @Override
    public void releaseExternalResources() {
        super.releaseExternalResources();
        this.timer.stop();
    }
}

