/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.netty.handler.codec.oneone;

import com.datastax.shaded.netty.channel.Channel;
import com.datastax.shaded.netty.channel.ChannelDownstreamHandler;
import com.datastax.shaded.netty.channel.ChannelEvent;
import com.datastax.shaded.netty.channel.ChannelHandlerContext;
import com.datastax.shaded.netty.channel.Channels;
import com.datastax.shaded.netty.channel.MessageEvent;

public abstract class OneToOneEncoder
implements ChannelDownstreamHandler {
    protected OneToOneEncoder() {
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent evt) throws Exception {
        if (!(evt instanceof MessageEvent)) {
            ctx.sendDownstream(evt);
            return;
        }
        MessageEvent e = (MessageEvent)evt;
        if (!this.doEncode(ctx, e)) {
            ctx.sendDownstream(e);
        }
    }

    protected boolean doEncode(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object encodedMessage;
        Object originalMessage = e.getMessage();
        if (originalMessage == (encodedMessage = this.encode(ctx, e.getChannel(), originalMessage))) {
            return false;
        }
        if (encodedMessage != null) {
            Channels.write(ctx, e.getFuture(), encodedMessage, e.getRemoteAddress());
        }
        return true;
    }

    protected abstract Object encode(ChannelHandlerContext var1, Channel var2, Object var3) throws Exception;
}

