/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.netty.handler.codec.spdy;

import com.datastax.shaded.netty.buffer.ChannelBuffer;
import com.datastax.shaded.netty.buffer.ChannelBuffers;
import com.datastax.shaded.netty.handler.codec.spdy.SpdyCodecUtil;
import com.datastax.shaded.netty.handler.codec.spdy.SpdyHeaderBlockRawDecoder;
import com.datastax.shaded.netty.handler.codec.spdy.SpdyHeadersFrame;
import com.datastax.shaded.netty.handler.codec.spdy.SpdyProtocolException;
import com.datastax.shaded.netty.handler.codec.spdy.SpdyVersion;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

final class SpdyHeaderBlockZlibDecoder
extends SpdyHeaderBlockRawDecoder {
    private final Inflater decompressor = new Inflater();
    private final ChannelBuffer decompressed = ChannelBuffers.buffer(4096);

    public SpdyHeaderBlockZlibDecoder(SpdyVersion spdyVersion, int maxHeaderSize) {
        super(spdyVersion, maxHeaderSize);
    }

    void decode(ChannelBuffer encoded, SpdyHeadersFrame frame) throws Exception {
        int numBytes;
        int len = this.setInput(encoded);
        do {
            numBytes = this.decompress(frame);
        } while (!this.decompressed.readable() && numBytes > 0);
        if (this.decompressor.getRemaining() != 0) {
            throw new SpdyProtocolException("client sent extra data beyond headers");
        }
        encoded.skipBytes(len);
    }

    private int setInput(ChannelBuffer compressed) {
        int len = compressed.readableBytes();
        if (compressed.hasArray()) {
            this.decompressor.setInput(compressed.array(), compressed.arrayOffset() + compressed.readerIndex(), len);
        } else {
            byte[] in = new byte[len];
            compressed.getBytes(compressed.readerIndex(), in);
            this.decompressor.setInput(in, 0, in.length);
        }
        return len;
    }

    private int decompress(SpdyHeadersFrame frame) throws Exception {
        byte[] out = this.decompressed.array();
        int off = this.decompressed.arrayOffset() + this.decompressed.writerIndex();
        try {
            int numBytes = this.decompressor.inflate(out, off, this.decompressed.writableBytes());
            if (numBytes == 0 && this.decompressor.needsDictionary()) {
                this.decompressor.setDictionary(SpdyCodecUtil.SPDY_DICT);
                numBytes = this.decompressor.inflate(out, off, this.decompressed.writableBytes());
            }
            if (frame != null) {
                this.decompressed.writerIndex(this.decompressed.writerIndex() + numBytes);
                super.decode(this.decompressed, frame);
                this.decompressed.discardReadBytes();
            }
            return numBytes;
        }
        catch (DataFormatException e) {
            throw new SpdyProtocolException("Received invalid header block", e);
        }
    }

    void reset() {
        this.decompressed.clear();
        super.reset();
    }

    public void end() {
        this.decompressed.clear();
        this.decompressor.end();
        super.end();
    }
}

