/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.convert;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.beans.DocumentObjectBinder;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.solr.core.convert.SolrConverter;
import org.springframework.data.solr.core.convert.SolrConverterBase;
import org.springframework.data.solr.core.convert.SolrjConverters;
import org.springframework.data.solr.core.mapping.SimpleSolrMappingContext;
import org.springframework.data.solr.core.mapping.SolrPersistentEntity;
import org.springframework.data.solr.core.mapping.SolrPersistentProperty;
import org.springframework.data.solr.core.query.Update;

public class SolrJConverter
extends SolrConverterBase
implements SolrConverter {
    private final MappingContext<? extends SolrPersistentEntity<?>, SolrPersistentProperty> mappingContext = new SimpleSolrMappingContext();

    public SolrJConverter() {
        this.initializeConverters();
    }

    public MappingContext<? extends SolrPersistentEntity<?>, SolrPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    @Override
    public <S, R> List<R> read(SolrDocumentList source, Class<R> type) {
        if (source == null) {
            return Collections.emptyList();
        }
        ArrayList<R> resultList = new ArrayList<R>(source.size());
        for (Map item : source) {
            resultList.add(this.read(type, item));
        }
        return resultList;
    }

    public <R> R read(Class<R> type, Map<String, ?> source) {
        if (!this.canConvert(SolrDocument.class, type)) {
            this.initializeTypedConverter(source, type);
        }
        return this.convert(source, type);
    }

    public void write(Object source, Map sink) {
        if (source == null) {
            return;
        }
        SolrInputDocument convertedDocument = this.convert(source, SolrInputDocument.class);
        sink.putAll(convertedDocument);
    }

    private void initializeConverters() {
        if (!this.canConvert(Update.class, SolrInputDocument.class)) {
            this.getConversionService().addConverter((Converter)new SolrjConverters.UpdateToSolrInputDocumentConverter());
        }
        if (!this.canConvert(Object.class, SolrInputDocument.class)) {
            this.getConversionService().addConverter((Converter)new SolrjConverters.ObjectToSolrInputDocumentConverter(new DocumentObjectBinder()));
        }
    }

    private <S> void initializeTypedConverter(Map<String, ?> source, Class<? extends S> rawType) {
        this.getConversionService().addConverter(source.getClass(), rawType, new SolrjConverters.SolrInputDocumentToObjectConverter<S>(rawType));
    }
}

