/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.Function;
import org.springframework.data.solr.core.query.Query;
import org.springframework.data.solr.core.query.SimpleField;
import org.springframework.data.solr.core.query.SolrPageRequest;
import org.springframework.util.Assert;

public class GroupOptions {
    int DEFAULT_GROUP_LIMIT = 1;
    int DEFAULT_CACHE_PERCENT = 0;
    private List<Field> groupByFields = new ArrayList<Field>(0);
    private List<Function> groupByFunctions = new ArrayList<Function>(0);
    private List<Query> groupByQuery = new ArrayList<Query>(0);
    private Integer offset = null;
    private Integer limit = null;
    private Sort sort;
    private boolean truncateFacets = false;
    private boolean groupFacets = false;
    private boolean totalCount = false;
    private boolean groupMain = false;
    private int cachePercent = this.DEFAULT_CACHE_PERCENT;

    public GroupOptions addGroupByField(Field field) {
        Assert.notNull((Object)field, (String)"Field for grouping must not be null.");
        Assert.hasText((String)field.getName(), (String)"Field.name for grouping must not be null/empty.");
        this.groupByFields.add(field);
        return this;
    }

    public List<Field> getGroupByFields() {
        return Collections.unmodifiableList(this.groupByFields);
    }

    public GroupOptions addGroupByField(String fieldName) {
        Assert.hasText((String)fieldName, (String)"Field.name for grouping must not be null/empty.");
        this.groupByFields.add(new SimpleField(fieldName));
        return this;
    }

    public GroupOptions addGroupByFunction(Function function) {
        Assert.notNull((Object)function, (String)"Function for grouping must not be null.");
        this.groupByFunctions.add(function);
        return this;
    }

    public List<Function> getGroupByFunctions() {
        return Collections.unmodifiableList(this.groupByFunctions);
    }

    public GroupOptions addGroupByQuery(Query query) {
        Assert.notNull((Object)query, (String)"Query for grouping must not be null.");
        this.groupByQuery.add(query);
        return this;
    }

    public List<Query> getGroupByQueries() {
        return Collections.unmodifiableList(this.groupByQuery);
    }

    public GroupOptions setOffset(Integer offset) {
        this.offset = offset == null ? null : Integer.valueOf(Math.max(0, offset));
        return this;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public GroupOptions setLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public GroupOptions addSort(Sort sort) {
        if (sort == null) {
            return this;
        }
        this.sort = this.sort == null ? sort : this.sort.and(sort);
        return this;
    }

    public Sort getSort() {
        return this.sort;
    }

    public GroupOptions setTotalCount(boolean groupCount) {
        this.totalCount = groupCount;
        return this;
    }

    public boolean isTotalCount() {
        return this.totalCount;
    }

    public GroupOptions setCachePercent(int cachePercent) {
        this.cachePercent = Math.max(0, Math.min(100, cachePercent));
        return this;
    }

    public int getCachePercent() {
        return this.cachePercent;
    }

    public GroupOptions setTruncateFacets(boolean truncateFacets) {
        this.truncateFacets = truncateFacets;
        return this;
    }

    public boolean isTruncateFacets() {
        return this.truncateFacets;
    }

    public GroupOptions setGroupFacets(boolean groupFacets) {
        this.groupFacets = groupFacets;
        return this;
    }

    public boolean isGroupFacets() {
        return this.groupFacets;
    }

    public GroupOptions setGroupMain(boolean groupMain) {
        this.groupMain = groupMain;
        return this;
    }

    public boolean isGroupMain() {
        return this.groupMain;
    }

    public Pageable getPageRequest() {
        if (this.limit == null && this.offset == null) {
            return null;
        }
        int limit = this.limit != null ? this.limit : this.DEFAULT_GROUP_LIMIT;
        int offset = this.offset != null ? this.offset : 0;
        return new SolrPageRequest(limit != 0 ? offset / limit : 0, limit, this.sort);
    }
}

