package main;

import main.core.Edge;
import main.core.Node;

import java.util.*;
import java.util.function.Predicate;

public class LambdaExpression {

    public static void main(String[] args) {

        // Runnable Interface
        Runnable ar = new Runnable(){
            @Override

            public void run(){
                System.out.println("Anonymous Runnable!");
            }
        };

        Runnable lr = () -> System.out.println("Lambda Runnable!");

        ar.run();
        lr.run();

        //----------------------------------

        // Comparator Interface
        List<Node> nodes = new ArrayList<Node>();

        // Sort with Inner Class
        Collections.sort(nodes, new Comparator<Node>() {
            public int compare(Node n1, Node n2) {
                return n1.getValue().compareTo(n2.getValue());
            }
        });

        System.out.println("=== Sorted Ascending ===");
        for(Node node:nodes){
            node.toString();
        }

        // Replace with lambdaExpression
        System.out.println("=== Sorted Ascending ===");
        Collections.sort(nodes, (Node n1, Node n2) -> n1.getValue().compareTo(n2.getValue()));

        for(Node node:nodes){
            node.toString();
        }

        System.out.println("=== Sorted Descending ===");
        Collections.sort(nodes, (n1, n2) -> n2.getValue().compareTo(n1.getValue()));

        for(Node node:nodes){
            node.toString();
        }

        //--------------------------------------

        // Functional Interface
        Print p = () -> System.out.println("Test");
        p.print();

        //--------------------------------------

        List<Edge> cities = new ArrayList<>();
        cities.add(new Edge(new Node("LA"), new Node("NY"), 50));
        cities.add(new Edge(new Node("Sydney"), new Node("Melbourne"), 30));
        cities.add(new Edge(new Node("Rome"), new Node("Venice"), 20));
        Predicate<Edge> edgePredicate = e -> e.getDist() >= 30;
        filter(edgePredicate, cities);

        //---------------------------------------

        List<String> myList =
                Arrays.asList("area", "block", "building", "city", "country");

        myList.stream()
                .filter(s -> s.startsWith("c"))
                .map(String::toUpperCase)
                .sorted()
                .forEach(System.out::println);

    }

    public static void filter(Predicate<Edge> predicate,
                                           List<Edge> items) {
        for(Edge item: items) {
            if(predicate.test(item)) {
                System.out.println(item.getOrigin().getValue().toString() + " to " + item.getDest().getValue().toString() + " : " + item.getDist());
            }
        }
    }
}
