package main;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegularExpression {

    public static void main(String[] args) throws IOException {

        Pattern pattern = Pattern.compile("\\d+");
        String[] st = pattern.split("20 potato, 10 tomato, 5 bread");
        for (int i = 1; i < st.length; i++) {
            System.out.println("recipe ingredient" + i + " : " + st[i]);
        }

        System.out.println("Matches: " + pattern.matches(".*", "abcd654xyz00"));

        String str = "abcd654xyz00";
        System.out.println("String Matches: " + str.matches(".*"));

        Pattern p = Pattern.compile("(cd)(\\d+\\w)(.*)", Pattern.CASE_INSENSITIVE);
        Matcher m = p.matcher("abCD45ee EE54dcBA");
        if (m.find()) {
            System.out.println("Group0: " + m.group(0));
            System.out.println("Group1: " + m.group(1));
            System.out.println("Group2: " + m.group(2));
            System.out.println("Group3: " + m.group(3));
            System.out.println("start(): " + m.start());
            System.out.println("end(): " + m.end());
        }

        System.out.println("Group count: " + m.groupCount());

        System.out.println(Pattern.matches("(\\d\\w)\\1", "2x2x")); //true
        System.out.println(Pattern.matches("(\\d\\w)\\1", "2x2z")); //false
        System.out.println(Pattern.matches("(A\\d)(bcd)\\2\\1", "A4bcdbcdA4")); //true
        System.out.println(Pattern.matches("(A\\d)(bcd)\\2\\1", "A4bcdbcdA5")); // false

        Pattern ptr = Pattern.compile("dd");
        Matcher mtr = ptr.matcher("dd3435dd");
        System.out.println("lookingAt(): " + mtr.lookingAt());
        System.out.println("matches(): " + mtr.matches());

        Pattern pt = Pattern.compile("Lion");
        // get a matcher object
        Matcher mt = pt.matcher("Lion is the strongest animal in jungle. Lion is smart.");
        String s1 = mt.replaceFirst("Bear");
        System.out.println("replaceFirst(): " + s1);
        String s2 = mt.replaceAll("Tiger");
        System.out.println("replaceAll()" + s2);
    }
}
