import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.Stage;

public class FxTextExampleSimple extends Application
{
	public static void main(String[] args)
	{
		Application.launch(args);
	}

	@Override
	public void start(Stage stage)
	{
		// Create the first Text Node
		Text text1 = new Text("This is my first Text Node");

		// Create the second Text Node
		Text text2 = new Text();
		text2.setText("This is my second Text Node");

		// Create the VBox
		VBox root = new VBox();
		// Add the Text Nodes to the VBox
		root.getChildren().addAll(text1, text2);
		// Set the Spacing to 10 px
		root.setSpacing(10);

		// Set the Styles of the VBox
		root.setStyle("-fx-padding: 10;" +
				"-fx-border-style: solid inside;" +
				"-fx-border-width: 2;" +
				"-fx-border-insets: 5;" +
				"-fx-border-radius: 5;" +
				"-fx-border-color: blue;");

		// Create the Scene
		Scene scene = new Scene(root,300,200);
		// Add the scene to the Stage
		stage.setScene(scene);
		// Set the title of the Stage
		stage.setTitle("A simple Text Node Example");
		// Display the Stage
		stage.show();
	}
}
