package com.jcg.examples;

import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.ClassPathResource;

import com.jcg.examples.entity.Book;
import com.jcg.examples.repo.BookRepo;

public class ApplicationTest
{

		
		public static void main(String[] args)
		{
				ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(new ClassPathResource("spring-couchbase-integration.xml").getPath());
				BookRepo bookRepo = context.getBean(BookRepo.class);
				
				Book book = new Book();
				book.setBookId(123);;
				book.setIsbnNumber(2133443554);
				book.setName("Kane And Abel by XYZ");
				bookRepo.save(book);
				
				Book anotherBook = new Book();
				anotherBook.setBookId(456);;
				anotherBook.setIsbnNumber(2133443554);
				anotherBook.setName("The Prodigal Daughter");
				bookRepo.save(anotherBook);
				
				Book retreivedBook = bookRepo.findOne(123l);
				
				System.out.println(retreivedBook);
				
				bookRepo.delete(456l);
				
				//bookRepo.getBooksByContainedWord("The");
				
				context.close();
		}

}
