/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import io.fabric.sdk.android.ActivityLifecycleManager;
import io.fabric.sdk.android.DefaultLogger;
import io.fabric.sdk.android.FabricKitsFinder;
import io.fabric.sdk.android.InitializationCallback;
import io.fabric.sdk.android.Kit;
import io.fabric.sdk.android.KitGroup;
import io.fabric.sdk.android.KitInfo;
import io.fabric.sdk.android.Logger;
import io.fabric.sdk.android.Onboarding;
import io.fabric.sdk.android.services.common.IdManager;
import io.fabric.sdk.android.services.concurrency.DependsOn;
import io.fabric.sdk.android.services.concurrency.PriorityThreadPoolExecutor;
import io.fabric.sdk.android.services.concurrency.UnmetDependencyException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;

public class Fabric {
    public static final String TAG = "Fabric";
    static final String ROOT_DIR = ".Fabric";
    static volatile Fabric singleton;
    static final Logger DEFAULT_LOGGER;
    static final boolean DEFAULT_DEBUGGABLE = false;
    private final Context context;
    private final Map<Class<? extends Kit>, Kit> kits;
    private final ExecutorService executorService;
    private final Handler mainHandler;
    private final InitializationCallback<Fabric> initializationCallback;
    private final InitializationCallback<?> kitInitializationCallback;
    private final IdManager idManager;
    private ActivityLifecycleManager activityLifecycleManager;
    private WeakReference<Activity> activity;
    private AtomicBoolean initialized;
    final Logger logger;
    final boolean debuggable;

    static Fabric singleton() {
        if (singleton == null) {
            throw new IllegalStateException("Must Initialize Fabric before using singleton()");
        }
        return singleton;
    }

    Fabric(Context context, Map<Class<? extends Kit>, Kit> kits, PriorityThreadPoolExecutor threadPoolExecutor, Handler mainHandler, Logger logger, boolean debuggable, InitializationCallback callback, IdManager idManager) {
        this.context = context;
        this.kits = kits;
        this.executorService = threadPoolExecutor;
        this.mainHandler = mainHandler;
        this.logger = logger;
        this.debuggable = debuggable;
        this.initializationCallback = callback;
        this.initialized = new AtomicBoolean(false);
        this.kitInitializationCallback = this.createKitInitializationCallback(kits.size());
        this.idManager = idManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Fabric with(Context context, Kit ... kits) {
        if (singleton != null) return singleton;
        Class<Fabric> clazz = Fabric.class;
        synchronized (Fabric.class) {
            if (singleton != null) return singleton;
            Fabric.setFabric(new Builder(context).kits(kits).build());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return singleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Fabric with(Fabric fabric) {
        if (singleton != null) return singleton;
        Class<Fabric> clazz = Fabric.class;
        synchronized (Fabric.class) {
            if (singleton != null) return singleton;
            Fabric.setFabric(fabric);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    private static void setFabric(Fabric fabric) {
        singleton = fabric;
        fabric.init();
    }

    public Fabric setCurrentActivity(Activity activity) {
        this.activity = new WeakReference<Activity>(activity);
        return this;
    }

    public Activity getCurrentActivity() {
        if (this.activity != null) {
            return (Activity)this.activity.get();
        }
        return null;
    }

    private void init() {
        this.setCurrentActivity(this.extractActivity(this.context));
        this.activityLifecycleManager = new ActivityLifecycleManager(this.context);
        this.activityLifecycleManager.registerCallbacks(new ActivityLifecycleManager.Callbacks(){

            @Override
            public void onActivityCreated(Activity activity, Bundle bundle) {
                Fabric.this.setCurrentActivity(activity);
            }

            @Override
            public void onActivityStarted(Activity activity) {
                Fabric.this.setCurrentActivity(activity);
            }

            @Override
            public void onActivityResumed(Activity activity) {
                Fabric.this.setCurrentActivity(activity);
            }
        });
        this.initializeKits(this.context);
    }

    public String getVersion() {
        return "1.3.10.97";
    }

    public String getIdentifier() {
        return "io.fabric.sdk.android:fabric";
    }

    void initializeKits(Context context) {
        Future<Map<String, KitInfo>> installedKitsFuture = this.getKitsFinderFuture(context);
        Collection<Kit> providedKits = this.getKits();
        Onboarding onboarding = new Onboarding(installedKitsFuture, providedKits);
        ArrayList<Kit> kits = new ArrayList<Kit>(providedKits);
        Collections.sort(kits);
        onboarding.injectParameters(context, this, InitializationCallback.EMPTY, this.idManager);
        for (Kit kit : kits) {
            kit.injectParameters(context, this, this.kitInitializationCallback, this.idManager);
        }
        onboarding.initialize();
        StringBuilder initInfo = Fabric.getLogger().isLoggable(TAG, 3) ? new StringBuilder("Initializing ").append(this.getIdentifier()).append(" [Version: ").append(this.getVersion()).append("], with the following kits:\n") : null;
        for (Kit kit : kits) {
            kit.initializationTask.addDependency(onboarding.initializationTask);
            this.addAnnotatedDependencies(this.kits, kit);
            kit.initialize();
            if (initInfo == null) continue;
            initInfo.append(kit.getIdentifier()).append(" [Version: ").append(kit.getVersion()).append("]\n");
        }
        if (initInfo != null) {
            Fabric.getLogger().d(TAG, initInfo.toString());
        }
    }

    void addAnnotatedDependencies(Map<Class<? extends Kit>, Kit> kits, Kit dependentKit) {
        DependsOn dependsOn = dependentKit.getClass().getAnnotation(DependsOn.class);
        if (dependsOn != null) {
            Class<?>[] dependencies;
            for (Class<?> dependency : dependencies = dependsOn.value()) {
                if (dependency.isInterface()) {
                    for (Kit kit : kits.values()) {
                        if (!dependency.isAssignableFrom(kit.getClass())) continue;
                        dependentKit.initializationTask.addDependency(kit.initializationTask);
                    }
                    continue;
                }
                Kit kit = kits.get(dependency);
                if (kit == null) {
                    throw new UnmetDependencyException("Referenced Kit was null, does the kit exist?");
                }
                dependentKit.initializationTask.addDependency(kits.get(dependency).initializationTask);
            }
        }
    }

    private Activity extractActivity(Context context) {
        if (context instanceof Activity) {
            return (Activity)context;
        }
        return null;
    }

    public ActivityLifecycleManager getActivityLifecycleManager() {
        return this.activityLifecycleManager;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public Handler getMainHandler() {
        return this.mainHandler;
    }

    public Collection<Kit> getKits() {
        return this.kits.values();
    }

    public static <T extends Kit> T getKit(Class<T> cls) {
        return (T)Fabric.singleton().kits.get(cls);
    }

    public static Logger getLogger() {
        if (singleton == null) {
            return DEFAULT_LOGGER;
        }
        return Fabric.singleton.logger;
    }

    public static boolean isDebuggable() {
        if (singleton == null) {
            return false;
        }
        return Fabric.singleton.debuggable;
    }

    public static boolean isInitialized() {
        return singleton != null && Fabric.singleton.initialized.get();
    }

    public String getAppIdentifier() {
        return this.idManager.getAppIdentifier();
    }

    public String getAppInstallIdentifier() {
        return this.idManager.getAppInstallIdentifier();
    }

    private static Map<Class<? extends Kit>, Kit> getKitMap(Collection<? extends Kit> kits) {
        HashMap<Class<? extends Kit>, Kit> map = new HashMap<Class<? extends Kit>, Kit>(kits.size());
        Fabric.addToKitMap(map, kits);
        return map;
    }

    private static void addToKitMap(Map<Class<? extends Kit>, Kit> map, Collection<? extends Kit> kits) {
        for (Kit kit : kits) {
            map.put(kit.getClass(), kit);
            if (!(kit instanceof KitGroup)) continue;
            Fabric.addToKitMap(map, ((KitGroup)((Object)kit)).getKits());
        }
    }

    InitializationCallback<?> createKitInitializationCallback(final int size) {
        return new InitializationCallback(){
            final CountDownLatch kitInitializedLatch;
            {
                this.kitInitializedLatch = new CountDownLatch(size);
            }

            public void success(Object o) {
                this.kitInitializedLatch.countDown();
                if (this.kitInitializedLatch.getCount() == 0L) {
                    Fabric.this.initialized.set(true);
                    Fabric.this.initializationCallback.success(Fabric.this);
                }
            }

            @Override
            public void failure(Exception exception) {
                Fabric.this.initializationCallback.failure(exception);
            }
        };
    }

    Future<Map<String, KitInfo>> getKitsFinderFuture(Context context) {
        FabricKitsFinder fabricKitsFinder = new FabricKitsFinder(context.getPackageCodePath());
        ExecutorService executorService = this.getExecutorService();
        return executorService.submit(fabricKitsFinder);
    }

    static {
        DEFAULT_LOGGER = new DefaultLogger();
    }

    public static class Builder {
        private final Context context;
        private Kit[] kits;
        private PriorityThreadPoolExecutor threadPoolExecutor;
        private Handler handler;
        private Logger logger;
        private boolean debuggable;
        private String appInstallIdentifier;
        private String appIdentifier;
        private InitializationCallback<Fabric> initializationCallback;

        public Builder(Context context) {
            if (context == null) {
                throw new IllegalArgumentException("Context must not be null.");
            }
            this.context = context.getApplicationContext();
        }

        public Builder kits(Kit ... kits) {
            if (this.kits != null) {
                throw new IllegalStateException("Kits already set.");
            }
            this.kits = kits;
            return this;
        }

        @Deprecated
        public Builder executorService(ExecutorService executorService) {
            return this;
        }

        public Builder threadPoolExecutor(PriorityThreadPoolExecutor threadPoolExecutor) {
            if (threadPoolExecutor == null) {
                throw new IllegalArgumentException("PriorityThreadPoolExecutor must not be null.");
            }
            if (this.threadPoolExecutor != null) {
                throw new IllegalStateException("PriorityThreadPoolExecutor already set.");
            }
            this.threadPoolExecutor = threadPoolExecutor;
            return this;
        }

        @Deprecated
        public Builder handler(Handler handler) {
            return this;
        }

        public Builder logger(Logger logger) {
            if (logger == null) {
                throw new IllegalArgumentException("Logger must not be null.");
            }
            if (this.logger != null) {
                throw new IllegalStateException("Logger already set.");
            }
            this.logger = logger;
            return this;
        }

        public Builder appIdentifier(String appIdentifier) {
            if (appIdentifier == null) {
                throw new IllegalArgumentException("appIdentifier must not be null.");
            }
            if (this.appIdentifier != null) {
                throw new IllegalStateException("appIdentifier already set.");
            }
            this.appIdentifier = appIdentifier;
            return this;
        }

        public Builder appInstallIdentifier(String appInstallIdentifier) {
            if (appInstallIdentifier == null) {
                throw new IllegalArgumentException("appInstallIdentifier must not be null.");
            }
            if (this.appInstallIdentifier != null) {
                throw new IllegalStateException("appInstallIdentifier already set.");
            }
            this.appInstallIdentifier = appInstallIdentifier;
            return this;
        }

        public Builder debuggable(boolean enabled) {
            this.debuggable = enabled;
            return this;
        }

        public Builder initializationCallback(InitializationCallback<Fabric> initializationCallback) {
            if (initializationCallback == null) {
                throw new IllegalArgumentException("initializationCallback must not be null.");
            }
            if (this.initializationCallback != null) {
                throw new IllegalStateException("initializationCallback already set.");
            }
            this.initializationCallback = initializationCallback;
            return this;
        }

        public Fabric build() {
            if (this.threadPoolExecutor == null) {
                this.threadPoolExecutor = PriorityThreadPoolExecutor.create();
            }
            if (this.handler == null) {
                this.handler = new Handler(Looper.getMainLooper());
            }
            if (this.logger == null) {
                this.logger = this.debuggable ? new DefaultLogger(3) : new DefaultLogger();
            }
            if (this.appIdentifier == null) {
                this.appIdentifier = this.context.getPackageName();
            }
            if (this.initializationCallback == null) {
                this.initializationCallback = InitializationCallback.EMPTY;
            }
            Map kitMap = this.kits == null ? new HashMap() : Fabric.getKitMap(Arrays.asList(this.kits));
            IdManager idManager = new IdManager(this.context, this.appIdentifier, this.appInstallIdentifier, kitMap.values());
            return new Fabric(this.context, kitMap, this.threadPoolExecutor, this.handler, this.logger, this.debuggable, this.initializationCallback, idManager);
        }
    }
}

