/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android;

import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.InitializationException;
import io.fabric.sdk.android.Kit;
import io.fabric.sdk.android.services.common.TimingMetric;
import io.fabric.sdk.android.services.concurrency.Priority;
import io.fabric.sdk.android.services.concurrency.PriorityAsyncTask;
import io.fabric.sdk.android.services.concurrency.UnmetDependencyException;

class InitializationTask<Result>
extends PriorityAsyncTask<Void, Void, Result> {
    private static final String TIMING_METRIC_TAG = "KitInitialization";
    final Kit<Result> kit;

    public InitializationTask(Kit<Result> kit) {
        this.kit = kit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onPreExecute() {
        super.onPreExecute();
        TimingMetric timingMetric = this.createAndStartTimingMetric("onPreExecute");
        boolean result = false;
        try {
            result = this.kit.onPreExecute();
        }
        catch (UnmetDependencyException ex) {
            throw ex;
        }
        catch (Exception ex) {
            Fabric.getLogger().e("Fabric", "Failure onPreExecute()", ex);
        }
        finally {
            timingMetric.stopMeasuring();
            if (!result) {
                this.cancel(true);
            }
        }
    }

    protected Result doInBackground(Void ... voids) {
        TimingMetric timingMetric = this.createAndStartTimingMetric("doInBackground");
        Result result = null;
        if (!this.isCancelled()) {
            result = this.kit.doInBackground();
        }
        timingMetric.stopMeasuring();
        return result;
    }

    @Override
    protected void onPostExecute(Result result) {
        this.kit.onPostExecute(result);
        this.kit.initializationCallback.success(result);
    }

    @Override
    protected void onCancelled(Result result) {
        this.kit.onCancelled(result);
        String message = this.kit.getIdentifier() + " Initialization was cancelled";
        InitializationException exception = new InitializationException(message);
        this.kit.initializationCallback.failure(exception);
    }

    @Override
    public Priority getPriority() {
        return Priority.HIGH;
    }

    private TimingMetric createAndStartTimingMetric(String event) {
        TimingMetric timingMetric = new TimingMetric(this.kit.getIdentifier() + "." + event, TIMING_METRIC_TAG);
        timingMetric.startMeasuring();
        return timingMetric;
    }
}

