/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android.services.common;

import android.content.Context;
import android.content.pm.PackageManager;
import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.services.cache.MemoryValueCache;
import io.fabric.sdk.android.services.cache.ValueLoader;

public class InstallerPackageNameProvider {
    private static final String NO_INSTALLER_PACKAGE_NAME = "";
    private final ValueLoader<String> installerPackageNameLoader = new ValueLoader<String>(){

        @Override
        public String load(Context context) throws Exception {
            String hostAppPackageName;
            PackageManager pm = context.getPackageManager();
            String installerPackageName = pm.getInstallerPackageName(hostAppPackageName = context.getPackageName());
            return installerPackageName == null ? InstallerPackageNameProvider.NO_INSTALLER_PACKAGE_NAME : installerPackageName;
        }
    };
    private final MemoryValueCache<String> installerPackageNameCache = new MemoryValueCache();

    public String getInstallerPackageName(Context appContext) {
        try {
            String name = this.installerPackageNameCache.get(appContext, this.installerPackageNameLoader);
            return NO_INSTALLER_PACKAGE_NAME.equals(name) ? null : name;
        }
        catch (Exception e) {
            Fabric.getLogger().e("Fabric", "Failed to determine installer package name", e);
            return null;
        }
    }
}

