/*
 * Decompiled with CFR 0.152.
 */
package io.fabric.sdk.android.services.settings;

import io.fabric.sdk.android.Fabric;
import io.fabric.sdk.android.Kit;
import io.fabric.sdk.android.services.common.AbstractSpiCall;
import io.fabric.sdk.android.services.common.CommonUtils;
import io.fabric.sdk.android.services.network.HttpMethod;
import io.fabric.sdk.android.services.network.HttpRequest;
import io.fabric.sdk.android.services.network.HttpRequestFactory;
import io.fabric.sdk.android.services.settings.SettingsRequest;
import io.fabric.sdk.android.services.settings.SettingsSpiCall;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

class DefaultSettingsSpiCall
extends AbstractSpiCall
implements SettingsSpiCall {
    static final String BUILD_VERSION_PARAM = "build_version";
    static final String DISPLAY_VERSION_PARAM = "display_version";
    static final String INSTANCE_PARAM = "instance";
    static final String SOURCE_PARAM = "source";
    static final String ICON_HASH = "icon_hash";
    static final String HEADER_DEVICE_MODEL = "X-CRASHLYTICS-DEVICE-MODEL";
    static final String HEADER_OS_BUILD_VERSION = "X-CRASHLYTICS-OS-BUILD-VERSION";
    static final String HEADER_OS_DISPLAY_VERSION = "X-CRASHLYTICS-OS-DISPLAY-VERSION";
    static final String HEADER_ADVERTISING_TOKEN = "X-CRASHLYTICS-ADVERTISING-TOKEN";
    static final String HEADER_INSTALLATION_ID = "X-CRASHLYTICS-INSTALLATION-ID";
    static final String HEADER_ANDROID_ID = "X-CRASHLYTICS-ANDROID-ID";

    public DefaultSettingsSpiCall(Kit kit, String protocolAndHostOverride, String url, HttpRequestFactory requestFactory) {
        this(kit, protocolAndHostOverride, url, requestFactory, HttpMethod.GET);
    }

    DefaultSettingsSpiCall(Kit kit, String protocolAndHostOverride, String url, HttpRequestFactory requestFactory, HttpMethod method) {
        super(kit, protocolAndHostOverride, url, requestFactory, method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject invoke(SettingsRequest requestData) {
        JSONObject toReturn = null;
        HttpRequest httpRequest = null;
        try {
            Map<String, String> queryParams = this.getQueryParamsFor(requestData);
            httpRequest = this.getHttpRequest(queryParams);
            httpRequest = this.applyHeadersTo(httpRequest, requestData);
            Fabric.getLogger().d("Fabric", "Requesting settings from " + this.getUrl());
            Fabric.getLogger().d("Fabric", "Settings query params were: " + queryParams);
            toReturn = this.handleResponse(httpRequest);
        }
        finally {
            if (httpRequest != null) {
                Fabric.getLogger().d("Fabric", "Settings request ID: " + httpRequest.header("X-REQUEST-ID"));
            }
        }
        return toReturn;
    }

    JSONObject handleResponse(HttpRequest httpRequest) {
        JSONObject toReturn;
        int statusCode = httpRequest.code();
        Fabric.getLogger().d("Fabric", "Settings result was: " + statusCode);
        if (this.requestWasSuccessful(statusCode)) {
            toReturn = this.getJsonObjectFrom(httpRequest.body());
        } else {
            Fabric.getLogger().e("Fabric", "Failed to retrieve settings from " + this.getUrl());
            toReturn = null;
        }
        return toReturn;
    }

    boolean requestWasSuccessful(int httpStatusCode) {
        return httpStatusCode == 200 || httpStatusCode == 201 || httpStatusCode == 202 || httpStatusCode == 203;
    }

    private JSONObject getJsonObjectFrom(String httpRequestBody) {
        try {
            return new JSONObject(httpRequestBody);
        }
        catch (Exception e) {
            Fabric.getLogger().d("Fabric", "Failed to parse settings JSON from " + this.getUrl(), e);
            Fabric.getLogger().d("Fabric", "Settings response " + httpRequestBody);
            return null;
        }
    }

    private Map<String, String> getQueryParamsFor(SettingsRequest requestData) {
        String instanceId;
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put(BUILD_VERSION_PARAM, requestData.buildVersion);
        queryParams.put(DISPLAY_VERSION_PARAM, requestData.displayVersion);
        queryParams.put(SOURCE_PARAM, Integer.toString(requestData.source));
        if (requestData.iconHash != null) {
            queryParams.put(ICON_HASH, requestData.iconHash);
        }
        if (!CommonUtils.isNullOrEmpty(instanceId = requestData.instanceId)) {
            queryParams.put(INSTANCE_PARAM, instanceId);
        }
        return queryParams;
    }

    private HttpRequest applyHeadersTo(HttpRequest request, SettingsRequest requestData) {
        this.applyNonNullHeader(request, "X-CRASHLYTICS-API-KEY", requestData.apiKey);
        this.applyNonNullHeader(request, "X-CRASHLYTICS-API-CLIENT-TYPE", "android");
        this.applyNonNullHeader(request, "X-CRASHLYTICS-API-CLIENT-VERSION", this.kit.getVersion());
        this.applyNonNullHeader(request, "Accept", "application/json");
        this.applyNonNullHeader(request, HEADER_DEVICE_MODEL, requestData.deviceModel);
        this.applyNonNullHeader(request, HEADER_OS_BUILD_VERSION, requestData.osBuildVersion);
        this.applyNonNullHeader(request, HEADER_OS_DISPLAY_VERSION, requestData.osDisplayVersion);
        this.applyNonNullHeader(request, HEADER_ADVERTISING_TOKEN, requestData.advertisingId);
        this.applyNonNullHeader(request, HEADER_INSTALLATION_ID, requestData.installationId);
        this.applyNonNullHeader(request, HEADER_ANDROID_ID, requestData.androidId);
        return request;
    }

    private void applyNonNullHeader(HttpRequest request, String key, String value) {
        if (value != null) {
            request.header(key, value);
        }
    }
}

