/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.core;

import android.os.AsyncTask;
import io.fabric.sdk.android.Fabric;

public class CrashTest {
    public void throwRuntimeException(String message) {
        throw new RuntimeException(message);
    }

    public int stackOverflow() {
        return this.stackOverflow() + (int)Math.random();
    }

    public void indexOutOfBounds() {
        int[] ints = new int[2];
        int intValue = ints[10];
        Fabric.getLogger().d("CrashlyticsCore", "Out of bounds value: " + intValue);
    }

    public void crashAsyncTask(final long delayMs) {
        AsyncTask<Void, Void, Void> bgTask = new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                try {
                    Thread.sleep(delayMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                CrashTest.this.throwRuntimeException("Background thread crash");
                return null;
            }
        };
        bgTask.execute((Object[])new Void[]{null});
    }

    public void throwFiveChainedExceptions() {
        try {
            try {
                try {
                    try {
                        this.privateMethodThatThrowsException("1");
                    }
                    catch (Exception ex) {
                        throw new RuntimeException("2", ex);
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException("3", ex);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("4", ex);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("5", ex);
        }
    }

    private void privateMethodThatThrowsException(String message) {
        throw new RuntimeException(message);
    }
}

